const generatedTrade = require("ib");
const _Trade = require("lodash");
const tradeWindow = document.getElementById('trade-window')
const showTradeWindowBtn = document.getElementById('show-trade-window')
const tradeTypeInput = document.getElementById('trade-type')
const executeBtn = document.getElementById('trade-execute')

const tradeQuantityInput = document.getElementById('trade-quantity')
const tradeLimitPriceInput = document.getElementById('trade-limit-price')
const tradeTakeProfitInput = document.getElementById('trade-take-profit')
const tradeStopLossInput = document.getElementById('trade-stop-loss')
const tradeInstrumentInput = document.getElementById('trade-instrument')
const tradeSideInput = document.getElementById('trade-side')

const page = document.querySelector(".page-name")


showTradeWindowBtn.addEventListener('click', function () {
  tradeWindow.classList.toggle('translate-x-full')
  showTradeWindowBtn.querySelector('svg').classList.toggle('rotate-180')
})

tradeTypeInput.addEventListener('change', function () {
  hideAllInputs()
  if (tradeTypeInput.value == "limit") {
    document.getElementById('trade-limit-price-container').classList.remove('hidden')
  } else if (tradeTypeInput.value == 'stop-loss') {
    document.getElementById('trade-stop-loss-container').classList.remove('hidden')
  } else if (tradeTypeInput.value == 'profit-stop') {
    document.getElementById('trade-stop-loss-container').classList.remove('hidden')
    document.getElementById('trade-take-profit-container').classList.remove('hidden')
  }
})

const hideAllInputs = () => {
  document.getElementById('trade-limit-price-container').classList.add('hidden')
  document.getElementById('trade-stop-loss-container').classList.add('hidden')
  document.getElementById('trade-take-profit-container').classList.add('hidden')
}

const executeOrder = () => {
  const type = tradeTypeInput.value
  const side = tradeSideInput.value
  const instrument = tradeInstrumentInput.value.replace(/-|_/, '/')
  const quantity = parseInt(tradeQuantityInput.value)
  // const tradeInstrumentType = instrumentDatalist.querySelector(`option[value="${instrument}"]`).dataset.type;
  const tradeInstrumentType = "";
  if (tradeInstrumentType == "oanda") {

    const oandaTrade = {
      order: {
        instrument: instrument,
        units: side === "buy" ? quantity : quantity * -1,
      }
    }

    switch (type) {

      case "market":
        oandaTrade.order.type = "MARKET"
        console.log(oandaTrade)
        break
      case "limit":
        oandaTrade.order.type = "LIMIT"
        oandaTrade.order.price = tradeLimitPriceInput.value
        console.log(oandaTrade)
        break
    }

    oanda.order.create(oandaParams.accountId, oandaTrade, (data) => {
      console.log(data)
      if (data.statusCode == 201) {
        alert('Order Created');
        tradeWindow.classList.add('translate-x-full')
        showTradeWindowBtn.querySelector('svg').classList.add('rotate-180')
        setTimeout(function () {
          if (page.classList.contains('positions')) {
            initPositions()
          }
        }, 500)
      }
    })
  }
  else {
    console.log(side);
    var ib = new (generatedTrade)({
      // clientId: 0,
      // host: '127.0.0.1',
      // port: 7496
    }).on('error', function (err) {
      if(err.message != "Market data farm connection is OK:usfarm" && err.message != "HMDS data farm connection is inactive but should be available upon demand.ushmds" && err.message != "Sec-def data farm connection is OK:secdefil" ){
        alert(err.message);
        playSound("rejected");
      }
    }).on('result', function (event, args) {
      if (!_Trade.includes(['accountSummary', 'accountSummaryEnd'], event)) {
      }

    }).on('orderStatus', function (id, status, filled, remaining, avgFillPrice, permId,
                                   parentId, lastFillPrice, clientId, whyHeld) {
      console.log(status);
      // console.log(
      //     '%s %s%d %s%s %s%d %s%d %s%d %s%d %s%d %s%d %s%d %s%s',
      //     chalk.cyan('[orderStatus]'),
      //     chalk.bold('id='), id,
      //     chalk.bold('status='), status,
      //     chalk.bold('filled='), filled,
      //     chalk.bold('remaining='), remaining,
      //     chalk.bold('avgFillPrice='), avgFillPrice,
      //     chalk.bold('permId='), permId,
      //     chalk.bold('parentId='), parentId,
      //     chalk.bold('lastFillPrice='), lastFillPrice,
      //     chalk.bold('clientId='), clientId,
      //     chalk.bold('whyHeld='), whyHeld
      if(status != "Inactive"){
        playSound("filled");
      }

    }).on('nextValidId', function (orderId) {
      console.log(
          '%s %s%d',
          '[nextValidId]',
          'orderId=', orderId
      );
      // ib.placeOrder(orderId, ib.contract.stock("APPL"), ib.order);
      ib.placeOrder(
          orderId,
          // ib.contract.stock(instrument),
           ib.contract.future("MNQ", "20230317", "USD", "CME", "2"),
          ib.order.market(side, quantity)  // safe, unreal value used for demo
      );
      // ib.placeOrder(orderId, ib.contract.option("MNQH3", "20230317", parseFloat(0), req.query.RIGHT, req.query.EXCHANGE, req.query.CURRENCY), ib.order.limit(req.query.ACTION, parseInt(req.query.QUANTITY), parseFloat(req.query.PRICE)));

      // ib.placeOrder(orderId,
      //      // ib.contract.future("MNQH3", "20230331", "USD", "GLOBEX", "2"),
      //     // ib.contract.option("MNQH3", "20230317", parseFloat("0"), "C", "", "USD"),
      //     ib.order.market("buy", 1)
      // );
      // ib.placeOrder(
      //     orderId,
      //     ib.contract.future("MNQH3", "20230317", "USD", "", "2"),
      //     ib.order.market('BUY', quantity)
      // )
      // console.log(ib.placeOrder(orderId,ib.contract.future("MNQH3", "20230314", "USD", "", "2"), ib.order.market('BUY',quantity)));
    }).on('openOrder', function (orderId, contract, order, orderState) {
      console.log(
          '%s %s %d %s %s %s',
        '[openOrder]',
         orderId,
         JSON.stringify(contract),
         JSON.stringify(order),
          JSON.stringify(orderState)
      );
    }).on('openOrderEnd', function () {
      console.log('[openOrderEnd]');
      alert('Order Filled');
    }).on('orderStatus', function (id, status, filled, remaining, avgFillPrice, permId,
                                   parentId, lastFillPrice, clientId, whyHeld) {
      console.log(
          '%s %s%d %s%s %s%d %s%d %s%d %s%d %s%d %s%d %s%d %s%s',
         '[orderStatus]',
          id,
           status,
          filled,
           remaining,
          avgFillPrice,
          permId,
           parentId,
           lastFillPrice,
           clientId,
          whyHeld
      );
      console.log("coming up");
    });
     // console.log(chalk.yellow('Placing orders...'));

      // Place orders
    ib.connect();
  }

}

executeBtn.addEventListener('click', function () {
  executeOrder()
})

function playSound(sound)
{
  if(sound == "rejected")
  {
    var audio = new Audio('./assets/audio/order_rejected.mp3');
    audio.play();
  }
  else if(sound == "filled"){
    var audio = new Audio('./assets/audio/order_filled.mp3');
    audio.play();
  }
}
