const oandaApiInput = document.getElementById('oanda-api-key')
const oandaAccountIdInput = document.getElementById('oanda-account-id')
const coinbaseApiKeyInput = document.getElementById('coinbase-api-key')
const coinbaseApiSecretInput = document.getElementById('coinbase-api-secret')
const coinbasePassphraseInput = document.getElementById('coinbase-passphrase')
const brokerInputs = document.querySelectorAll('.broker-inputs');

const generalTabHeader = document.getElementById('generalTabHeader')
const bindingsTabHeader = document.getElementById('bindingsTabHeader')
const general_tab = document.getElementById('general-tab')
const bindings_tab = document.getElementById('bindings-tab')

const quick_buy = document.getElementById('keys-quick-buy')
const quick_sell = document.getElementById('keys-quick-sell')
const quick_news = document.getElementById('keys-quick-news')
const quick_help = document.getElementById('keys-quick-help')






generalTabHeader.addEventListener("click", function(){
    general_tab.style.display = "block";
    bindings_tab.style.display = "none";
});

bindingsTabHeader.addEventListener("click", function(){
    general_tab.style.display = "none";
    bindings_tab.style.display = "block";
});


const fetchUserData = () => {
  const uid = localStorage.getItem('usr');
  const fd = new FormData();
  fd.append('action', 'fetch_user_info');
  fd.append('uid', uid)
  fetch('https://impulsetrading.io/api-new.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(res => {
      oandaApiInput.value = res.oanda
      oandaAccountIdInput.value = res.oanda_account_id
      coinbaseApiKeyInput.value = res.cb_api
      coinbaseApiSecretInput.value = res.cb_api_secret
      coinbasePassphraseInput.value = res.cb_passphrase
      oandaParams.apiKey = res.oanda
      oandaParams.accountId = res.oanda_account_id
      coinbaseParams.apiKey = res.cb_api
      coinbaseParams.apiSecret = res.cb_api_secret
      coinbaseParams.passphrase = res.cb_passphrase
      //  Keybindings
      quick_buy.value = res.quick_buy
      quick_sell.value = res.quick_sell
      quick_news.value = res.quick_news
      quick_help.value = res.quick_help

      var bindings = []
      bindings.push(quick_buy.value);
      bindings.push(quick_sell.value);
      bindings.push(quick_news.value);
      bindings.push(quick_help.value);

      localStorage.setItem('oandaApiKey', res.oanda)
      localStorage.setItem('oandaAccountId', res.oanda_account_id)
      localStorage.setItem('coinbaseApiKey', res.cb_api)
      localStorage.setItem('coinbaseApiSecret', res.cb_api_secret)
      localStorage.setItem('coinbasePassphrase', res.cb_passphrase)
      localStorage.setItem('bindings', bindings);
    })
}

fetchUserData()

const updateUserInfo = () => {
  const fd = new FormData()
  fd.append('action', 'update_broker_info')
  fd.append('uid', localStorage.getItem('usr'))
  fd.append('oanda_api_key', oandaApiInput.value)
  fd.append('oanda_account_id', oandaAccountIdInput.value)
  fd.append('coinbase_api', coinbaseApiKeyInput.value)
  fd.append('coinbase_api_secret', coinbaseApiSecretInput.value)
  fd.append('coinbase_passphrase', coinbasePassphraseInput.value)
  fd.append('quick_buy', quick_buy.value)
  fd.append('quick_sell', quick_sell.value)
  fd.append('quick_help', quick_help.value)
  fd.append('quick_news', quick_news.value)
  fetch('https://impulsetrading.io/api-new.php', {
    method: "POST",
    body: fd
  })
}

oandaAccountIdInput.addEventListener('change', function () {
  let value = oandaAccountIdInput.value
  oanda.account.get(value, (data) => {
    if (data.statusMessage !== "OK") {
      alert('Please enter a valid Account ID')
    } else {
      localStorage.setItem('oandaAccountId', value)
    }
  })
})

oandaApiInput.addEventListener('change', function () {
  let value = oandaApiInput.value
  oanda.setToken(value)
  if (oandaParams.accountId) {
    oanda.account.get(oandaParams.accountId, (data) => {
      if (data.statusMessage !== "OK") {
        alert('Please enter a valid API Key')
        oanda.setToken(localStorage.getItem('oandaApiKey'))
      } else {
        localStorage.setItem('oandaApiKey', value)
      }
    })
  }
})


brokerInputs.forEach(input => {
  input.addEventListener('change', updateUserInfo)
})

