const generatedNew = require("ib");
const _lo = require("lodash");
const generated = require("ib");
const _ = require("lodash");
const positionsTable = document.getElementById('positions-table')
const echarts = require('echarts');
// const {CandleGranularity} = require("coinbase-pro-node");
//Charts Portion
var chartDom = document.getElementById('port_chart');
var myChart = echarts.init(chartDom);

const initPositions = () => {
  positionsTable.innerHTML = "";
  oanda.position.listOpen(oandaParams.accountId, (data) => {
    let positions = data.body.positions

    positions.forEach(position => {
      console.log(position)
      let html, plColor, uplColor, currentPrice;

      let instrument = position.instrument
      let instrumentDisplay = position.instrument.replace('_', '/')
      let unrealizedPL = position.unrealizedPL

      let longUnits = position.long.units
      let shortUnits = position.short.units

      if (unrealizedPL <= 0) {
        uplColor = "red"
      } else {
        uplColor = "green"
      }

      oanda.pricing.get(oandaParams.accountId, {instruments: instrument}, (data) => {
        currentPrice = data.body.prices[0].closeoutBid
        if (currentPrice) {

          const unrealizedPLFormatted = unrealizedPL.toLocaleString('en-US', {
            minimumIntegerDigits: 1,
            minimumFractionDigits: 4
          })

          html = `
          <tr class="group position-group" data-instrument="${instrument}" data-type="oanda" data-id="${longUnits > 0 ? position.long.tradeIDs[0] : position.short.tradeIDs[0]}">
            <td class="opacity-0 cursor-pointer group-hover:opacity-100 mt-[2px] mr-1">
              <img src="./assets/icons/bell.svg" alt="bell"/>
            </td>
            <td class="font-bold instrument">${instrumentDisplay}</td>
            <td class="text-right quantity">${longUnits > 0 ? longUnits : shortUnits}</td>
            <td class="text-right unrealized-p-l text-brand-${uplColor}">${unrealizedPLFormatted}</td>
            <td class="text-right pr-6 current-price">${currentPrice}</td>
            <td class="pr-6 close-position cursor-pointer"
                data-id="${longUnits > 0 ? position.long.tradeIDs[0] : position.short.tradeIDs[0]}"
                data-type="oanda">Close</td>
          </tr>
          `

          // html = `
          // <tr class="group position-group" data-instrument="${instrument}" data-type="oanda" data-id="${longUnits > 0 ? position.long.tradeIDs[0] : position.short.tradeIDs[0]}">
          //   <td class="opacity-0 cursor-pointer group-hover:opacity-100 float-right mt-[2px] mr-1"><img src="./assets/icons/bell.svg"
          //                                                                                alt="bell"></td>
          //   <td class="font-bold instrument">${instrumentDisplay}</td>
          //   <td class="text-right quantity">${longUnits > 0 ? longUnits : shortUnits}</td>
          //   <td class="text-right unrealized-p-l text-brand-${uplColor}">${unrealizedPL}</td>
          //   <td class="text-right pr-3 current-price pr-6">${currentPrice}</td>
          // </tr>
          // `

          positionsTable.innerHTML += html;
        }
      })
    })
  })

  coinbase.rest.account.listAccounts().then(wallets => {
    wallets.forEach(wallet => {
      if (wallet.balance > 0) {
        let currentPrice = 0
        let html = `
          <tr class="group position-group" data-type="coinbase" data-id="${wallet.id}">
            <td class="opacity-0 cursor-pointer group-hover:opacity-100 mt-[2px] mr-1">
              <img src="./assets/icons/bell.svg" alt="bell"/>
            </td>
            <td></td>
            <td class="font-bold instrument">${wallet.currency}</td>
            <td class="text-right quantity">${wallet.available}</td>
            <td class="text-right unrealized-p-l text-brand"></td>
            <td class="text-right pr-6 current-price">${currentPrice}</td>
            <td class="pr-6 close-position cursor-pointer" data-id="${wallet.currency}-USD" data-type="coinbase" data-size="${wallet.available}">Close</td>
          </tr>
          `

        // let html = `
        //   <tr class="group position-group" data-type="coinbase" data-id="${wallet.id}">
        //     <td class="opacity-0 cursor-pointer group-hover:opacity-100 float-right mt-[2px] mr-1"><img src="./assets/icons/bell.svg"
        //                                                                                  alt="bell"></td>
        //     <td class="font-bold instrument">${wallet.currency}</td>
        //     <td class="text-right quantity">${wallet.available}</td>
        //     <td class="text-right unrealized-p-l text-brand"></td>
        //     <td class="text-right pr-3 current-price pr-6">${currentPrice}</td>
        //   </tr>
        //   `

        positionsTable.innerHTML += html;

      }
    })
  })
}


const updateTable = () => {
  const tableElements = document.querySelectorAll('.position-group')
  tableElements.forEach(el => {
    if (el.dataset.type == "oanda") {
      oanda.position.listOpen(oandaParams.accountId, (data) => {
        let positions = data.body.positions
        positions.forEach((position) => {
          if (position.instrument == el.dataset.instrument) {
            let unrealizedPL = parseFloat(position.unrealizedPL)
            let uplSelector = el.querySelector('.unrealized-p-l')

            const unrealizedPLFormatted = unrealizedPL.toLocaleString('en-US', {
              minimumIntegerDigits: 1,
              minimumFractionDigits: 4
            })

            if (unrealizedPL <= 0) {
              uplSelector.innerHTML = `<td class="text-right unrealized-p-l text-brand-red">${unrealizedPLFormatted}</td>`
            } else {
              uplSelector.innerHTML = `<td class="text-right unrealized-p-l text-brand-green">${unrealizedPLFormatted}</td>`
            }
          }
        })

        let instrumentSelector = el.querySelector('.instrument')
        let currentPriceSelector = el.querySelector('.current-price')
        oanda.pricing.get(oandaParams.accountId, {instruments: instrumentSelector.innerText}, (data) => {
          let currentPrice = data.body.prices[0].closeoutBid
          currentPriceSelector.innerText = currentPrice
        })
      })
    } else if (el.dataset.type == "coinbase") {
      coinbase.rest.account.getAccount(el.dataset.id).then(account => {
        console.log(account)
        // console.log(row)
        const row = document.querySelector(`[data-id="${account.id}"]`)
        const quantity = row.querySelector('.quantity')
        quantity.innerHTML = account.available
      })
    }
  })
}

const closePosition = (id, type, size) => {
  if (confirm('Are you sure you want to close out of this position?')) {
    if (type == "oanda") {
      oanda.trade.close(oandaParams.accountId, id, {units: "ALL"}, (data) => {
        console.log(data)
        if (data.body.errorCode) {
          console.log(data.body.errorMessage)
        } else {
          positionsTable.innerHTML = ""
          initPositions()
          alert('Position Closed');
        }
      })
    } else if (type == "coinbase") {
      const newOrder = {
        type: 'market',
        side: 'sell',
        stp: 'dc',
        time_in_force: 'GTC',
        cancel_after: 'min',
        post_only: 'false',
        product_id: globalInstrument,
        size
      }
      coinbase.rest.order.placeOrder(newOrder)
        .then(order => {
          console.log(order)
        })
    }
  }
}

document.addEventListener("DOMContentLoaded", initPositions)

document.getElementById('positions').addEventListener("dragend", function() {
  window.open("#", "_blank", "top=500,left=200,frame=true,nodeIntegration=true,enableRemoteModule=true,contextIsolation=false");

})

document.addEventListener('click', (e) => {
  if (e.target.classList.contains('close-position')) {
    let id = e.target.dataset.id
    let type = e.target.dataset.type
    let size = e.target.dataset.size
    closePosition(id, type, size)
  }
})

// executeTradeBtn.addEventListener('click', () => {
//   setTimeout(initPositions, 500)
// })

const calculateTotalPL = () => {
  const plCells = document.querySelectorAll('.unrealized-p-l ');
  let total = 0
  plCells.forEach(cell => {
    console.log(cell.innerText)
    total = parseFloat(total) + parseFloat(cell.innerText)
    total = total.toLocaleString('en-US', {
      minimumIntegerDigits: 1,
      minimumFractionDigits: 4
    })
  })
  const totalRow = document.getElementById('total-unrealised-pl')
  totalRow.innerText = total
}


setInterval(function () {
  updateTable()
  calculateTotalPL()
}, 2000)


var myChart = echarts.init(chartDom, 'dark');
var option;
var IBPortPercentage = 90;
var coinbasePortPercentage = 0 ;
var oandaPortPercentage = 10;
option = {
  tooltip: {
    trigger: 'item',
    formatter: '{a} <br/>{b}: {c} ({d}%)'
  },
  legend: {
    data: [
      'Direct',
      'Marketing',
      'Search Engine',
      'Email',
      'Union Ads',
      'Video Ads',
      'Baidu',
      'Google',
      'Bing',
      'Others'
    ]
  },
  series: [
    {
      name: 'Access From',
      type: 'pie',
      selectedMode: 'single',
      radius: [0, '30%'],
      label: {
        position: 'inner',
        fontSize: 14
      },
      labelLine: {
        show: false
      },
      data: [
        { value: oandaPortPercentage, name: 'Oanda' },
        { value: coinbasePortPercentage, name: 'Coinbase' },
        { value: IBPortPercentage, name: 'IB'}
      ]
    },
    {
      name: 'Access From',
      type: 'pie',
      radius: ['45%', '60%'],
      labelLine: {
        length: 30
      },
      label: {
        formatter: '{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ',
        backgroundColor: '#F6F8FC',
        borderColor: '#8C8D8E',
        borderWidth: 1,
        borderRadius: 4,
        rich: {
          a: {
            color: '#6E7079',
            lineHeight: 22,
            align: 'center'
          },
          hr: {
            borderColor: '#8C8D8E',
            width: '100%',
            borderWidth: 1,
            height: 0
          },
          b: {
            color: '#4C5058',
            fontSize: 14,
            fontWeight: 'bold',
            lineHeight: 33
          },
          per: {
            color: '#fff',
            backgroundColor: '#4C5058',
            padding: [3, 4],
            borderRadius: 4
          }
        }
      },
      data: [
        { value: 1048, name: 'Baidu' },
        { value: 335, name: 'Direct' },
        { value: 310, name: 'Email' },
        { value: 251, name: 'Google' },
        { value: 234, name: 'Union Ads' },
        { value: 147, name: 'Bing' },
        { value: 135, name: 'Video Ads' },
        { value: 102, name: 'Others' }
      ]
    }
  ]
};

option && myChart.setOption(option);

