const generatedNew = require("ib");
const ordersTableBody = document.getElementById('orders-body')
const pastTransactionsTableBody = document.getElementById('past-transactions-body')


document.addEventListener('click', function (e) {
  if (e.target.classList.contains('cancel-order')) {
    const orderId = e.target.dataset.id
    oanda.order.cancel(oandaParams.accountId, orderId, (res) => {
      if (res.statusMessage == "OK" && res.statusCode == "200") {
        getOpenOrders()
      }
    })
  }
})

const updateTable = () => {
  ordersTableBody.innerHTML = ""
  getOpenOrders()
  getPastTransactions()
}

const getOpenOrders = () => {
  oanda.order.list(oandaParams.accountId, {}, (data) => {
    const orders = data.body.orders
    orders.forEach(order => {
      console.log(order)
      const instrumentDisplay = order.instrument.replace('_', '/')

      let html = `
      <tr>
        <td class="pl-6">${instrumentDisplay}</td>
        <td>${order.type}</td>
        <td>${order.state}</td>
        <td class="text-right">${order.units}</td>
        <td class="text-right pr-6">${order.price}</td>
        <td>${order.timeInForce}</td>
        <td><button class="cancel-order" data-id="${order.id}">Cancel</button></td>
      </tr>
      `

      ordersTableBody.innerHTML += html
    })
  })
// ib.disconnect();
//   var ib = new (generatedNew)({
//     clientId: 8427717,
//   }).on('error', function (err) {
//     console.error(err.message);
//   }).on('result', function (event, args) {
//   }).on('nextValidId', function (orderId){
//     // console.log(ib.reqOpenOrders());
//     console.log(orderId);
//     console.log("ran");
//     ib.reqOpenOrders()
//   });
//
//   // ib.clientId(1)
//   ib.connect();
//
//
//
  // ib.reqOpenOrders();
  // ib.on('openOrderEnd', function () {
  //   // console.log(chalk.yellow("closing positions"));
  //   console.log("test");
  //   // ib.disconnect();
  // });
}

const getPastTransactions = () => {
  oanda.transaction.list(oandaParams.accountId, {}, (res) => {
    const id = parseInt(res.body.lastTransactionID) - 250
    const acceptedTypes = ["ORDER_FILL"]

    oanda.transaction.since(oandaParams.accountId, {id}, (transactions) => {
      console.log(transactions)
      const allTransactions = transactions.body.transactions.reverse()
      allTransactions.forEach(transaction => {
        let accepted = false;
        acceptedTypes.forEach(type => {
          if (transaction.type == type && accepted == false) {
            accepted = true
          }
        })
        if (accepted) {
          const instrumentDisplay = transaction.instrument.replace('_', '/')
          const date = new Date(transaction.time).toLocaleString('en-US', {
            month: 'short',
            day: '2-digit',
            hour: "numeric",
            minute: 'numeric'
          });


          let html = `
          <tr>
            <td class="pl-6 whitespace-nowrap">${instrumentDisplay}</td>
            <td class="whitespace-nowrap">${transaction.reason}</td>
            <td class="whitespace-nowrap">${date}</td>
            <td class="text-right whitespace-nowrap">${transaction.units}</td>
            <td class="text-right whitespace-nowrap pr-6">${transaction.price}</td>
            <td class="text-right whitespace-nowrap pr-6">${transaction.pl}</td>
          </tr>
          `

          pastTransactionsTableBody.innerHTML += html
        }
      })
    })
  })
}

updateTable()

