const newsSection = document.getElementById('news-section')
let articlesViewed = localStorage.getItem('articles_viewed')
let bookmarkedArticles = localStorage.getItem('bookmarked_articles')
const loadingArticles = document.getElementById('loading-articles')
let viewableArticles = 100;
let newsOffset = 0

document.addEventListener('click', function (e) {
  console.log(e.target)
  if (e.target.classList.contains('news-wrapper')) {
    e.target.querySelector('.news-content').classList.toggle('hidden')
    if (e.target.querySelector('.unread-dot')) {
      if (e.target.querySelector('.unread-dot').classList.contains('hidden')) {
        e.target.querySelector('.news-header').classList.toggle('opacity-60')
      } else {
        e.target.querySelector('.unread-dot').classList.add('hidden')
      }
    } else {
      e.target.querySelector('.news-header').classList.toggle('opacity-60')
    }

    e.target.querySelector('.news-header').classList.toggle('bg-brand-blue')
    e.target.querySelector('.news-header').classList.toggle('text-white')

    if (articlesViewed) {
      let article = e.target.dataset.id
      let parsed = JSON.parse(articlesViewed)
      if (!parsed.includes(article)) {
        parsed.push(article)
        localStorage.setItem('articles_viewed', JSON.stringify(parsed))
      }
    } else {
      let article = [e.target.dataset.id]
      localStorage.setItem('articles_viewed', JSON.stringify(article))
    }

  } else if (e.target.classList.contains('bookmark')) {
    if (bookmarkedArticles) {
      const bookmarkParsed = JSON.parse(bookmarkedArticles)
      if (bookmarkParsed.includes(e.target.dataset.id)) {
        const fd = new FormData();
        fd.append('action', 'delete_bookmark')
        fd.append('post_id', e.target.dataset.id)
        fd.append('uid', localStorage.getItem('usr'))

        fetch('https://impulsetrading.io/api-new.php', {
          method: "POST",
          body: fd
        })
        e.target.querySelector('img').src = './assets/icons/bookmark_empty.svg'
        removeBookmarkFromStorage(e.target.dataset.id)


      } else {
        const fd = new FormData();
        fd.append('action', 'update_bookmarks')
        fd.append('post_id', e.target.dataset.id)
        fd.append('uid', localStorage.getItem('usr'))

        fetch('https://impulsetrading.io/api-new.php', {
          method: "POST",
          body: fd
        })
        e.target.querySelector('img').src = './assets/icons/bookmark_filled.svg'
        addBookmarkToStorage(e.target.dataset.id)
      }

    }


  } else if (e.target.id == "bookmarks-btn") {
    clearFilter()
    filterBookmarks()
    dimNewsTabs()
    document.getElementById('bookmarks-btn').classList.remove('opacity-60')

  } else if (e.target.id == "news-btn") {
    filterArticles('news')
    dimNewsTabs()
    document.getElementById('news-btn').classList.remove('opacity-60')

  } else if (e.target.id == "economic-events-btn") {
    filterArticles('economic_event')
    dimNewsTabs()
    document.getElementById('economic-events-btn').classList.remove('opacity-60')

  } else if (e.target.id == "all-news-btn") {
    clearFilter()
    dimNewsTabs()
    document.getElementById('all-news-btn').classList.remove('opacity-60')
  }
})

const dimNewsTabs = () => {
  document.getElementById('bookmarks-btn').classList.add('opacity-60')
  document.getElementById('all-news-btn').classList.add('opacity-60')
  document.getElementById('news-btn').classList.add('opacity-60')
  document.getElementById('economic-events-btn').classList.add('opacity-60')

}


const loadNews = () => {
  const endpoint = 'https://impulsetrading.io/api-new.php'
  const fd = new FormData()

  fd.append('action', 'get_viewable_articles')
  fd.append('offset', newsOffset)

  fetch(endpoint, {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(data => {
      // console.log(data)
      let dateSorted = data.sort((a, b) => {
        let dateA = new Date(a.date + " " + a.time)
        let dateB = new Date(b.date + " " + b.time)
        return dateB - dateA
      })

      dateSorted.forEach(article => {
        if (article.title) {
          let formattedDate = new Date(article.date + " " + article.time).toLocaleString('en-US', {
            month: 'short',
            day: '2-digit',
            hour: "numeric",
            minute: 'numeric'
          });


          let unread, bookmarkIcon, headerOpacity = "";
          if (articlesViewed) {
            let parsed = JSON.parse(articlesViewed)
            if (!parsed.includes(article.id)) {
              unread = `
            <div
            class="unread-dot absolute bg-brand h-2 w-2 rounded-full top-1/2 -translate-y-1/2 left-2 pointer-events-none"></div>
            `
            } else {
              unread = ''
              headerOpacity = "opacity-60"
            }
          } else {
            unread = `
            <div
            class="unread-dot absolute bg-brand h-2 w-2 rounded-full top-1/2 -translate-y-1/2 left-2 pointer-events-none"></div>
            `
          }

          if (bookmarkedArticles) {
            let parsed = JSON.parse(bookmarkedArticles)
            if (parsed.includes(article.id)) {
              bookmarkIcon = './assets/icons/bookmark_filled.svg'
            } else {
              bookmarkIcon = './assets/icons/bookmark_empty.svg'
            }
          } else {
            bookmarkIcon = './assets/icons/bookmark_empty.svg'
          }

          let description = article.desp
          description = description.replaceAll('&lt;', '<')
          description = description.replaceAll('&gt;', '>')
          description = description.replaceAll('<p>', '<p class="mb-4">')


          let html = `
        <div class="news-wrapper relative grid grid-cols-12 mt-2 cursor-pointer" data-id="${article.id}" data-category="${article.category}">
          ${unread}
          <div class="col-span-12 grid grid-cols-12 news-header pointer-events-none ${headerOpacity}">
            <p class="pl-6 col-span-9 pointer-events-none">${article.title}</p>
            <p class="col-span-1 text-center pointer-events-none">${article.source}</p>
            <p class="col-span-2 pr-6 text-right pointer-events-none">${formattedDate}</p>
          </div>
          <div class="news-content hidden col-span-12 px-6 text-white cursor-default">
            <div class="flex items-center">
              <p class="opacity-60 pl-4 pr-2">${article.date}</p>
              <button class="bookmark" data-id="${article.id}">
                <img src="${bookmarkIcon}" alt="" class="pointer-events-none"/>
              </button>
            </div>
            <div class="opacity-80 pl-4">${description}</div>
          </div>
        </div>
        `

          newsSection.innerHTML += html;
        }
      })
      loadingArticles.classList.add('hidden')
    })
}

const checkBookmarks = () => {
  const fd = new FormData();
  fd.append('action', 'fetch_bookmarked_posts')
  fd.append('uid', localStorage.getItem('usr'))
  fetch('https://impulsetrading.io/api-new.php', {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(bookmarks => {
      // console.log(bookmarks)
      bookmarks.forEach(bookmark => {
        // console.log(bookmark)
        // console.log(bookmark.post_id)
        addBookmarkToStorage(bookmark.post_id)
      })
    })
}

const addBookmarkToStorage = (post_id) => {
  if (bookmarkedArticles) {
    const bookmarkParsed = JSON.parse(bookmarkedArticles)
    if (!bookmarkParsed.includes(post_id)) {
      bookmarkParsed.push(post_id)
      localStorage.setItem('bookmarked_articles', JSON.stringify(bookmarkParsed))
      bookmarkedArticles = JSON.stringify(bookmarkParsed)
    }
  } else {
    let post = [post_id]
    localStorage.setItem('bookmarked_articles', JSON.stringify(post))
    bookmarkedArticles = JSON.stringify(post)
  }
}

const removeBookmarkFromStorage = (post_id) => {
  const bookmarkParsed = JSON.parse(bookmarkedArticles)
  const index = bookmarkParsed.indexOf(post_id)
  if (index > -1) {
    bookmarkParsed.splice(index, 1)
    localStorage.setItem('bookmarked_articles', JSON.stringify(bookmarkParsed))
    bookmarkedArticles = JSON.stringify(bookmarkParsed)
  }
}

const filterBookmarks = () => {
  const articles = newsSection.querySelectorAll('.news-wrapper')
  const bookmarkParsed = JSON.parse(bookmarkedArticles)
  articles.forEach(article => {
    if (!bookmarkParsed.includes(article.dataset.id)) {
      article.classList.add('hidden')
    }
  })
}

const clearFilter = () => {
  const articles = newsSection.querySelectorAll('.news-wrapper')
  articles.forEach(article => {
    article.classList.remove('hidden')
  })
}

const filterArticles = (filter) => {
  clearFilter()
  const articles = newsSection.querySelectorAll('.news-wrapper')
  articles.forEach(article => {
    if (article.dataset.category != filter) {
      article.classList.add('hidden')
    }
  })
}

newsSection.addEventListener('keyup', function () {
  const newsSearchBar = document.getElementById('news-search')
  let input = newsSearchBar.value
  searchArticles(input)
})

const searchArticles = (input) => {
  console.log(input)
  const articles = newsSection.querySelectorAll('.news-wrapper')
  const tabs = newsSection.querySelectorAll('.nav-bar a')
  let currentTab = ""
  tabs.forEach(tab => {
    if (!tab.classList.contains('opacity-60')) {
      currentTab = tab.dataset.tab
    }
  })

  if (input.length > 2) {
    articles.forEach(article => {
      if (!article.textContent.toLowerCase().includes(input.toLowerCase())) {
        article.classList.add('hidden')
      } else {
        article.classList.remove('hidden')
      }
    })
  } else {
    articles.forEach(article => {
      article.classList.remove('hidden')
    })
  }

  if (currentTab == "bookmarks") {
    filterBookmarks();
  }
}

checkBookmarks()
loadNews()

document.addEventListener('scroll', function (e) {
  console.log(window.scrollY)
  const offsetTop = window.scrollY
  const scrollCheck = (2000 + (2000 * newsOffset * 1.55))
  if (offsetTop > scrollCheck && viewableArticles < 1200) {
    loadingArticles.classList.remove('hidden')
    newsOffset++
    loadNews()
  }
})