const messagesContainer = document.querySelector('.messages')
const sendBtn = document.getElementById('send-button')
const chatInput = document.getElementById('chat-field')
let chatLength, oldChatId;
let oldDate;

const initChat = () => {
  fetchChatroomNames()
  fetchUsernames()
}

const userId = localStorage.getItem('usr')

const createMessage = (msg) => {
  let newDate = new Date(msg.date_time)
  let time = new Date(msg.date_time).toLocaleString('en-US', {
    hour12: true,
    hour: "2-digit",
    minute: "2-digit"
  })
  let html = ""
  if (oldDate) {
    if (oldDate.getDate() < newDate.getDate() && oldDate.getMonth() <= newDate.getMonth()) {
      let currentDayText = oldDate.toLocaleString('en-US', {
        dateStyle: "medium"
      })
      html += `
        <div class="flex items-center mt-4 opacity-20">
          <div class="grow bg-white h-[1px] ml-4"></div>
          <p class="px-4">${currentDayText}</p>
          <div class="grow bg-white h-[1px] mr-4"></div>
        </div>
      `
      oldDate = newDate
    }
  } else {
    oldDate = newDate
  }
  html += `
    <div class="message relative text-brand-off-white mt-4">
      <p class="absolute left-4">${time}</p>
      <p class="pl-24 pr-6">
        <span class="opacity-100 text-brand font-bold username-display cursor-pointer" data-user="${msg.uid}">${msg.username}: </span> 
        ${msg.message}
      </p>
    </div>
    `

  messagesContainer.innerHTML += html;
}

const fetchUsernames = () => {
  const usersDiv = document.getElementById('users')
  const fd = new FormData();
  fd.append('action', 'fetch_chat_names')
  fd.append('uid', userId)

  fetch('https://impulsetrading.io/api-chat.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(chats => {
      chats.forEach(chat => {
       if (!document.querySelector(`.chat-selector[data-id="${chat.id}"][data-room="0"]`)) {
         let time = new Date(chat.date_time).toLocaleString('en-US', {
           hour12: true,
           hour: "2-digit",
           minute: "2-digit"
         })
         let html = `<a href="javascript:void(0)" data-id="${chat.id}" data-room="0" class="chat-selector px-6 py-1 opacity-70 flex justify-between align-center">${chat.username} <span>${time}</span></a>`
         usersDiv.innerHTML += html
       }
      })
    })
}

const fetchUserChat = (chatId, messageReceived = true, jumpChat = false) => {
  oldDate = undefined;
  const fd = new FormData();
  fd.append('action', 'fetch_user_chat')
  fd.append('uid', userId)
  fd.append('chat_id', chatId)

  fetch('https://impulsetrading.io/api-chat.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(chatMessages => {
      messagesContainer.innerHTML = "";
      messagesContainer.dataset.activeChat = chatId;
      messagesContainer.dataset.room = 0;
      console.log(messageReceived)
      if (chatLength < chatMessages.length && chatId == oldChatId && messageReceived) {
        beep();
      }
      chatMessages.forEach(msg => {
        createMessage(msg)
      })
      chatLength = chatMessages.length
      oldChatId = chatId
      const messages = document.querySelectorAll('.message')
      if (jumpChat) {
        messagesContainer.scrollTop = 1000 * messages.length
      }
    })
}

const fetchChatroomNames = () => {
  const chatroomsDiv = document.getElementById('chatrooms')
  const fd = new FormData();
  fd.append('action', 'fetch_chatroom_names')

  fetch('https://impulsetrading.io/api-chat.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(chats => {
      chats.forEach(chat => {
        let time = new Date(chat.date_time).toLocaleString('en-US', {
          hour12: true,
          hour: "2-digit",
          minute: "2-digit"
        })
        let html = `<a href="javascript:void(0)" data-id="${chat.id}" data-room="1" class="chat-selector px-6 py-1 opacity-70 flex justify-between align-center">${chat.room_name} <span>${time}</span></a>`
        chatroomsDiv.innerHTML += html
      })
    })
}

const fetchChatroomMessages = (roomId, messageReceived = true, jumpChat = false) => {
  oldDate = undefined;
  const fd = new FormData();
  fd.append('action', 'fetch_chatroom_messages')
  fd.append('room_id', roomId)

  fetch('https://impulsetrading.io/api-chat.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(messages => {
      messagesContainer.innerHTML = "";
      messagesContainer.dataset.activeChat = roomId;
      messagesContainer.dataset.room = 1;
      if (chatLength < messages.length && roomId == oldChatId && messageReceived) {
        beep();
      }
      messages.forEach(msg => {
        createMessage(msg)
      })
      chatLength = messages.length
      oldChatId = roomId
      const allMessages = document.querySelectorAll('.message')
      if (jumpChat) {
        messagesContainer.scrollTop = 10000 * allMessages.length
      }
    })
}


const sendMessage = (call) => {
  const message = chatInput.value
  const chatId = messagesContainer.dataset.activeChat
  const chatRoom = messagesContainer.dataset.room
  const fd = new FormData()

  fd.append('action', call)
  fd.append('message', message)
  fd.append('uid', userId)
  fd.append('chat_id', chatId)

  fetch('https://impulsetrading.io/api-chat.php', {
    method: "POST",
    body: fd
  })
    .then(res => res.json())
    .then(result => {
      console.log(result)
      chatInput.value = ""
      if (chatRoom > 0) {
        fetchChatroomMessages(chatId, false, true)
      } else {
        fetchUserChat(chatId, false, true)
      }
    })
}


document.addEventListener('click', (e) => {
  if (e.target.classList.contains('chat-selector')) {
    const currentChat = e.target
    const chats = document.querySelectorAll('.chat-selector')
    chats.forEach(chat => {
      chat.classList.remove('chat-active')
    })
    currentChat.classList.add('chat-active')

    if (currentChat.dataset.room == 1) {
      fetchChatroomMessages(currentChat.dataset.id, false, true)
    } else {
      fetchUserChat(currentChat.dataset.id, false, true)
    }

  } else if (e.target.classList.contains('username-display')) {
    let user = e.target
    console.log(user)
    if (user.dataset.user != userId) {
      const chats = document.querySelectorAll('.chat-selector')
      chats.forEach(chat => {
        if (chat.dataset.id != user.dataset.user) {
          chat.classList.remove('chat-active')
        } else if (chat.dataset.id == user.dataset.user && chat.dataset.room == 0) {
          chat.classList.add('chat-active')
        }
      })


      fetchUserChat(user.dataset.user, false, true)
    }
  }
})

const refreshMessages = setInterval(function () {
  const chatId = messagesContainer.dataset.activeChat
  const chatRoom = messagesContainer.dataset.room
  if (chatRoom > 0) {
    fetchChatroomMessages(chatId)
  } else {
    fetchUserChat(chatId)
  }
  fetchUsernames();
}, 1000)


const processMessage = () => {
  if (messagesContainer.dataset.room == 0) {
    sendMessage("send_user_message")
  } else {
    sendMessage("send_chatroom_message")
  }
}

sendBtn.addEventListener('click', processMessage)

document.addEventListener('keyup', function (e) {
  if (e.code == "Enter") {
    processMessage()
  }
})

initChat()

function beep() {
  var snd = new Audio("data:audio/wav;base64,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");
  snd.play();
}