const echarts = require('echarts');
// const {CandleGranularity} = require("coinbase-pro-node");
var chartDom = document.getElementById('main');
var myChart = echarts.init(chartDom);
var option;
let chartData, chartTimes;
let drawingData = [];
let drawingStatus = false;
const sizeOfSymbol = 20

const awaitOanda = (type) => {
  const oandaData = new Promise((resolve) => {
    oanda.instrument.candles(globalInstrument, chartParams, function (data) {
      chartData = [];
      chartTimes = [];
      for (const candle of data.body.candles) {
        let time = new Date(candle.time).toLocaleString('en-US')
        let currentCandle = [candle.mid.c, candle.mid.o, candle.mid.l, candle.mid.h]
        chartData.push(currentCandle)
        chartTimes.push(time)
      }
      var date = new Date(chartTimes[chartTimes.length-1]);
      date.setMinutes(date.getMinutes()+5);
      console.log(date);
      chartData.push("[-]", "[-]", "[-]", "[-]");
      chartTimes.push(date.toLocaleString('en-US'));
      var date = new Date(chartTimes[chartTimes.length-1]);
      date.setMinutes(date.getMinutes() + 5);
      console.log(date);
      chartData.push("[-]", "[-]", "[-]", "[-]");
      chartTimes.push(date.toLocaleString('en-US'));
      resolve('done')
      // chartData.push(['-', '-', '-', '-']);
    })
  })

  oandaData.then(() => {
    if (type == "init") {
      assignData()
      myChart.setOption(option);
      loadDrawings()
    } else if (type == "reload") {
      option.series[0].data = chartData
      option.xAxis.data = chartTimes
      assignData()
      myChart.setOption(option);
    }
  })
}


let chartCurrentDate = new Date()
let chartStartDate = new Date()
chartStartDate.setDate(chartCurrentDate.getDate() - 1);

// const coinbaseGetData = () => {
//   chartData = [];
//   chartTimes = [];
//   coinbase.rest.product.getCandles(globalInstrument, {
//     granularity: CandleGranularity.ONE_MINUTE,
//     start: chartStartDate.getTime(),
//     end: chartCurrentDate.getTime()
//   }).then(candles => {
//     candles.forEach(candle => {
//       console.log(candle)
//       let time = new Date(candle.openTimeInISO).toLocaleString('en-US')
//       let currentCandle = [candle.close, candle.open, candle.low, candle.high]
//       chartData.push(currentCandle)
//       chartTimes.push(time)
//     })
//     assignData()
//     myChart.setOption(option);
//   })
// }

const initChart = () => {
  if (instrumentType == "oanda") {
    awaitOanda("init")
  } else if (instrumentType == "coinbase") {
    // coinbaseGetData()
  }
}

const reloadChart = () => {
  if (instrumentType == "oanda") {
    awaitOanda("reload")
  }
  console.log('reloaded')

}

setInterval(reloadChart, 3000)
setTimeout(initChart, 1000)

//Echart Stuff
function calculateMA(dayCount, data) {
  var result = [];
  for (var i = 0, len = data.length; i < len; i++) {
    if (i < dayCount) {
      result.push('-');
      continue;
    }
    var sum = 0;
    for (var j = 0; j < dayCount; j++) {
      sum += +data[i - j][1];
    }
    result.push(sum / dayCount);
  }
  return result;
}
function calculateCurrentPrice(data, price) {
  var result = [];
  for (var i = 0, len = data.length; i < len; i++) {
    result.push(price);
  }
  return result;
}
function calculateCurrentPriceDot(data, price) {
  var result = [];
  for (var i = 0, len = data.length; i < len-1; i++) {
    result.push("-");
  }
  result.push(price);
  return result;
}


function assignData() {
  option = {
    legend: {
      data: ['MA5', 'MA10', 'MA20', 'MA30'],
      inactiveColor: '#777',
      textStyle: {
        color: '#8392A5'
      },
    },
    tooltip: {
      backgroundColor: "#222",
      borderColor: "#444",
      trigger: 'axis',
      axisPointer: {
        animation: false,
        type: 'cross',
        lineStyle: {
          color: '#777',
          width: 1,
          opacity: 1
        },
      },
      textStyle: {
        color: "#ddd"
      },
      //Hide tooltip but keep axisPointer
      // position: ['-50%', '-50%']
    },
    xAxis: {
      type: 'category',
      data: chartTimes,
      axisLine: {lineStyle: {color: '#8392A5'}},
      splitLine: {
        show: true,
        lineStyle: {
          opacity: 0.15,
          type: [5, 5],
        }
      }
    },
    yAxis: {
      scale: true,
      position: 'right',
      axisLine: {lineStyle: {color: '#8392A5'}},
      splitLine: {
        // show: true,
        lineStyle: {
          opacity: 0.15,
          type: [5, 5],
        }
      },
    },
    grid: {
      bottom: 80
    },
    dataZoom: [
      {
        textStyle: {
          color: '#8392A5'
        },

        handleIcon:
          'path://M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
        dataBackground: {
          areaStyle: {
            color: '#8392A5'
          },
          lineStyle: {
            opacity: 0.8,
            color: '#8392A5'
          }
        },
        brushSelect: true
      },
      {
        type: 'inside',
      }
    ],
    series: [
      {
        type: 'candlestick',
        name: 'Day',
        data: chartData,
        itemStyle: {
          color: '#FD1050',
          color0: '#0CF49B',
          borderColor: '#FD1050',
          borderColor0: '#0CF49B'
        },
      },
      {
        name: 'MA5',
        type: 'line',
        data: calculateMA(5, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'Current Price',
        type: 'line',
        data: calculateCurrentPrice(chartData, chartData[chartData.length-9][0]),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1,
          type: 'dashed',
          color: 'orange',
          opacity: 0.7
        },
        label: {
          normal: {
            show: false,
            position: 'right',
            textStyle: {
              fontSize: 12
            },
            formatter: chartData[chartData.length-9][0]
          }
        }
      },
      {
        name: 'Price Value',
        type: 'line',
        data: calculateCurrentPriceDot(chartTimes,chartData[chartData.length-9][0]),
        smooth: true,
        showSymbol: true,
        lineStyle: {
          width: 1,
          type: 'dashed',
          color: 'orange',
          opacity: 0.7
        },
        label: {
          normal: {
            show: true,
            position: 'right',
            textStyle: {
              fontSize: 12
            },
            formatter: chartData[chartData.length-9][0]
          }
        }
      },
      {
        name: 'MA10',
        type: 'line',
        data: calculateMA(10, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'MA20',
        type: 'line',
        data: calculateMA(20, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'MA30',
        type: 'line',
        data: calculateMA(30, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
    ],
    graphic: [
      {
        type: 'group',
        bounding: 'raw',
        left: "25px",
        top: 20,
        z: 100,
        onclick: function () {
          drawingStatus = 1
          // this._children[0].style.fill = "#FFA500aa"
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: drawingStatus > 0 ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: 'Draw',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "80px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M5";
          resetTime(1)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M5" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '5M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "135px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M15";
          resetTime(5)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M15" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'

            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '15M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "190px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M30";
          resetTime(10)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M30" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '30M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "245px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "H1";
          resetTime(30)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "H1" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '1H',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "300px",
        top: 20,
        z: 100,
        active: false,
        onclick: function () {
          chartParams.granularity = "D";
          resetTime(180)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "D" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '1D',
              font: '16px sans-serif'
            }
          }
        ]
      },
    ],
  };
}

var zr = myChart.getZr();

let drawingNumber = 0;
let drawingClick = 0;

zr.on('click', function (params) {
  if (drawingStatus == 1) {
    // First click is the draw button
    drawingStatus = 2;
  } else if (drawingStatus == 2) {
    const options = myChart.getOption()
    const date = chartTimes[options.xAxis[0].axisPointer.value + 1]
    const price = options.yAxis[0].axisPointer.value

    if (drawingClick == 0) {
      drawingData.push([[date, price]])
      console.log(option.series)
      const newDrawing = {
        id: `drawings-${drawingNumber}`,
        name: "drawing",
        type: 'line',
        smooth: false,
        symbolSize: sizeOfSymbol,
        data: drawingData[drawingNumber],
        lineStyle: {
          color: "#FFA500"
        }
      }
      option.series.push(newDrawing)
      drawingClick++
    } else {
      drawingData[drawingNumber].push([date, price])
      myChart.setOption({
        series: [{
          id: `drawings-${drawingNumber}`,
          data: drawingData[drawingNumber]
        }]
      })
      saveDrawings()
      drawingClick = 0
      drawingNumber++
      drawingStatus = 0
    }
    reloadChart()
  }
});

zr.on('dblclick', function () {
  const options = myChart.getOption()
  const date = chartTimes[options.xAxis[0].axisPointer.value + 1]
  const price = options.yAxis[0].axisPointer.value
  console.log(date, price)

  showTradeWindowBtn.click()
  document.getElementById('trade-type').value = "limit"
  document.getElementById('trade-limit-price-container').classList.remove('hidden')
  document.getElementById('trade-instrument').value = globalInstrument.replace(/-|_/, '/')
  document.getElementById('trade-quantity').value = 100
  document.getElementById('trade-limit-price').value = price.toFixed(4)
})

const saveDrawings = () => {
  const drawings = JSON.parse(localStorage.getItem(`drawings-${globalInstrument}-${chartParams.granularity}`))
  if (drawings) {
    drawings.push(drawingData[drawingNumber])
    localStorage.setItem(`drawings-${globalInstrument}-${chartParams.granularity}`, JSON.stringify(drawings))
  } else {
    localStorage.setItem(`drawings-${globalInstrument}-${chartParams.granularity}`, JSON.stringify([drawingData[drawingNumber]]))
  }
}

const loadDrawings = () => {
  resetDrawings()
  const drawings = JSON.parse(localStorage.getItem(`drawings-${globalInstrument}-${chartParams.granularity}`))
  console.log(drawings)
  drawings.forEach(drawing => {
    drawingData.push([drawing[0], drawing[1]])
    const newDrawing = {
      id: `drawings-${drawingNumber}`,
      name: "drawing",
      type: 'line',
      smooth: false,
      symbolSize: sizeOfSymbol,
      data: drawingData[drawingNumber],
      lineStyle: {
        color: "#FFA500"
      }
    }
    option.series.push(newDrawing)
    drawingNumber++
  })
  console.log(option)
}

const resetDrawings = () => {
  const series = myChart.getOption().series
  console.log(series)
  if (series.length > 5) {
    const data = series.splice(0, 5)
    console.log(data)
    myChart.setOption({
      series: data
    })
  }
}

const date = new Date()

window.onresize = function () {
  myChart.resize()
}

const resetTime = (daysBack) => {
  const currentDate = new Date()
  const startDate = new Date()
  startDate.setDate(currentDate.getDate() - daysBack)
  chartParams.from = Math.floor(startDate.getTime() / 1000)
}

// Reload chart when changing instrument

instrumentInput.addEventListener('change', function (e) {
  initChart()
})

// const setCircles = (num) => {
//   myChart.setOption({
//     graphic: [{
//       id: `drawing-${num}`,
//       type: 'circle',
//       bounding: 'raw',
//       left: 500,
//       top: 500,
//       z: 100,
//       shape: {
//         cx: 0,
//         cy: 0,
//         r: sizeOfSymbol / 2
//       },
//       style: {
//         fill: "#FFFFFF"
//       },
//       draggable: true,
//       ondrag: function () {
//         console.log('dragging')
//       }
//     }]
//   })
// }

const setCircles = () => {
  myChart.setOption({
    graphic: drawingData.map((item, index) => {
      return {
        id: `drawings-${index}-left`,
        type: 'circle',
        position: myChart.convertToPixel('grid', item[0]),
        z: 100,
        shape: {
          cx: 0,
          cy: 0,
          r: sizeOfSymbol / 2
        },
        style: {
          fill: "#FFFFFF"
        },
        draggable: true,
        ondrag: function () {
          onPointDragging(index, 'left')
        }
      }
    })
  })

  myChart.setOption({
    graphic: drawingData.map((item, index) => {
      return {
        id: `drawings-${index}-right`,
        type: 'circle',
        position: myChart.convertToPixel('grid', item[1]),
        z: 100,
        shape: {
          cx: 0,
          cy: 0,
          r: sizeOfSymbol / 2
        },
        style: {
          fill: "#FFFFFF"
        },
        draggable: true,
        ondrag: function () {
          onPointDragging(index, 'right')
        }
      }
    })
  })
}

function onPointDragging(dataIndex, pos) {
  const options = myChart.getOption()
  const date = chartTimes[options.xAxis[0].axisPointer.value + 1]
  const price = options.yAxis[0].axisPointer.value


  drawingData[dataIndex][pos == "left" ? 0 : 1] = [date, price]

  console.log(dataIndex)
  console.log(date, price)
  myChart.setOption({
    series: [
      {
        id: `drawings-${dataIndex}`,
        data: drawingData[dataIndex]
      }
    ]
  })
}
