const echarts = require('echarts');
// const {CandleGranularity} = require("coinbase-pro-node");
var chartDom = document.getElementById('main');
var myChart = echarts.init(chartDom);
var option;
let chartData, chartTimes;
let drawingData = [];
let drawingStatus = false;
const sizeOfSymbol = 20
let chartGranularity = chartParams.granularity;

const oandaGetData = () => {
  oanda.instrument.candles(globalInstrument, chartParams, function (data) {
    chartData = [];
    chartTimes = [];
    console.log(data.body.candles);
    data.body.candles.forEach(candle => {
      let time = new Date(candle.time).toLocaleString('en-US')
      let currentCandle = [candle.mid.c, candle.mid.o, candle.mid.l, candle.mid.h]
      chartData.push(currentCandle)
      chartTimes.push(time)
    })
    assignData()
    myChart.setOption(option);

  })
}

let chartCurrentDate = new Date()
let chartStartDate = new Date()
chartStartDate.setDate(chartCurrentDate.getDate() - 1);

const coinbaseGetData = () => {
  chartData = [];
  chartTimes = [];
  coinbase.rest.product.getCandles(globalInstrument, {
    granularity: CandleGranularity.ONE_MINUTE,
    start: chartStartDate.getTime(),
    end: chartCurrentDate.getTime()
  }).then(candles => {
    candles.forEach(candle => {
      console.log(candle)
      let time = new Date(candle.openTimeInISO).toLocaleString('en-US')
      let currentCandle = [candle.close, candle.open, candle.low, candle.high]
      chartData.push(currentCandle)
      chartTimes.push(time)
    })
    assignData()
    myChart.setOption(option);
  })
}

coinbaseGetData();

const initChart = () => {
  if (instrumentType == "oanda") {
    oandaGetData()
  } else if (instrumentType == "coinbase") {
    coinbaseGetData()
  }
}
initChart()

setInterval(initChart, 10000)
setTimeout(initChart, 1000)


chartParams.to = Math.floor((chartCurrentDate.getTime()) / 1000)

//Echart Stuff
function calculateMA(dayCount, data) {
  var result = [];
  for (var i = 0, len = data.length; i < len; i++) {
    if (i < dayCount) {
      result.push('-');
      continue;
    }
    var sum = 0;
    for (var j = 0; j < dayCount; j++) {
      sum += +data[i - j][1];
    }
    result.push(sum / dayCount);
  }
  return result;
}

function assignData() {
  option = {
    legend: {
      data: ['MA5', 'MA10', 'MA20', 'MA30'],
      inactiveColor: '#777',
      textStyle: {
        color: '#8392A5'
      },
    },
    tooltip: {
      backgroundColor: "#222",
      borderColor: "#444",
      trigger: 'axis',
      axisPointer: {
        animation: false,
        type: 'cross',
        lineStyle: {
          color: '#777',
          width: 1,
          opacity: 1
        },
      },
      textStyle: {
        color: "#ddd"
      }
      //Hide tooltip but keep axisPointer
      // position: ['-50%', '-50%']
    },
    xAxis: {
      type: 'category',
      data: chartTimes,
      axisLine: {lineStyle: {color: '#8392A5'}},
      splitLine: {
        show: true,
        lineStyle: {
          opacity: 0.15,
          type: [5, 5],
        }
      }
    },
    yAxis: {
      scale: true,
      axisLine: {lineStyle: {color: '#8392A5'}},
      splitLine: {
        // show: true,
        lineStyle: {
          opacity: 0.15,
          type: [5, 5],
        }
      },
    },
    grid: {
      bottom: 80
    },
    dataZoom: [
      {
        textStyle: {
          color: '#8392A5'
        },
        handleIcon:
          'path://M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
        dataBackground: {
          areaStyle: {
            color: '#8392A5'
          },
          lineStyle: {
            opacity: 0.8,
            color: '#8392A5'
          }
        },
        brushSelect: true
      },
      {
        type: 'inside'
      }
    ],
    series: [
      {
        type: 'candlestick',
        name: 'Day',
        data: chartData,
        itemStyle: {
          color: '#FD1050',
          color0: '#0CF49B',
          borderColor: '#FD1050',
          borderColor0: '#0CF49B'
        }
      },
      {
        name: 'MA5',
        type: 'line',
        data: calculateMA(5, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'MA10',
        type: 'line',
        data: calculateMA(10, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'MA20',
        type: 'line',
        data: calculateMA(20, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        name: 'MA30',
        type: 'line',
        data: calculateMA(30, chartData),
        smooth: true,
        showSymbol: false,
        lineStyle: {
          width: 1
        }
      },
      {
        id: drawingNumber,
        type: 'line',
        smooth: true,
        symbolSize: 20,
        data: drawingData,
        lineStyle: {
          width: 1,
          opacity: 0.8
        },
      }
    ],
    graphic: [
      {
        id: "draw-btn",
        type: 'group',
        bounding: 'raw',
        left: "25px",
        top: 20,
        z: 100,
        onclick: function () {
          drawingStatus = true
          this._children[0].style.fill = "#FFA500aa"
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: drawingStatus ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: 'Draw',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "80px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M5";
          resetTime(1)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M5" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '5M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "135px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M15";
          resetTime(5)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M15" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'

            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '15M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "190px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "M30";
          resetTime(10)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "M30" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '30M',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "245px",
        top: 20,
        z: 100,
        onclick: function () {
          chartParams.granularity = "H1";
          resetTime(30)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "H1" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '1H',
              font: '16px sans-serif'
            }
          }
        ]
      },
      {
        type: 'group',
        bounding: 'raw',
        left: "300px",
        top: 20,
        z: 100,
        active: false,
        onclick: function () {
          chartParams.granularity = "D";
          resetTime(180)
          initChart();
        },
        children: [
          {
            type: 'rect',
            left: 'center',
            top: 'center',
            z: 100,
            shape: {
              width: 50,
              height: 25
            },
            style: {
              fill: chartParams.granularity == "D" ? "#FFA500aa" : 'rgba(255,255,255,0.3)'
            }
          },
          {
            type: 'text',
            left: 'center',
            top: 'center',
            z: 100,
            style: {
              fill: '#fff',
              text: '1D',
              font: '16px sans-serif'
            }
          }
        ]
      },
    ],
  };
}

var zr = myChart.getZr();

let drawingNumber = 0;
let drawingClick = 0;

zr.on('click', function (params) {
  if (drawingStatus == true) {
    var pointInPixel = [params.offsetX, params.offsetY];
    var pointInGrid = myChart.convertFromPixel('grid', pointInPixel);

    if (myChart.containPixel('grid', pointInPixel)) {
      const chartData = drawingData[drawingNumber]
      if (drawingClick == 0) {
        drawingData.push([pointInGrid]);
        const newDrawing = {
          id: drawingNumber,
          type: 'line',
          smooth: false,
          symbolSize: sizeOfSymbol,
          data: chartData,
        }
        option.series.push(newDrawing)
        assignData()
        myChart.setOption(option);
        drawingClick++
      } else if (drawingClick == 1) {
        chartData.push(pointInGrid);
        myChart.setOption({
          series: [{
            id: drawingNumber,
            data: chartData
          }]
        });
        drawingClick = 0
        drawingNumber++
        drawingStatus = false
        myChart.setOption({
          graphic: [{
            id: "draw-btn",
            children: [{
              type: 'rect',
              style: {
                fill: 'rgba(255,255,255,0.3)'
              }
            }]
          }]
        });
        saveDrawings()
      }
      console.log(option)
    }
  }
});


const saveDrawings = () => {
  localStorage.setItem(`drawings-${chartGranularity}`, JSON.stringify(drawingData))
}

window.onresize = function () {
  myChart.resize()
}

option && myChart.setOption(option);

const resetTime = (daysBack) => {
  const currentDate = new Date()
  const startDate = new Date()
  startDate.setDate(currentDate.getDate() - daysBack)
  chartParams.from = Math.floor(startDate.getTime() / 1000)
}

// Reload chart when changing instrument

instrumentInput.addEventListener('change', function (e) {
  initChart()
})
