const transactionHistory = []
const instrumentHistory = []
let currentMonth;
let currentYear;
const days = document.querySelectorAll('.day');
const todayMonthDisplay = document.getElementById('today-month')
const todayYearDisplay = document.getElementById('today-year')
const todaysDate = new Date();
let bookmarkedArticles = localStorage.getItem('bookmarked_articles')
const loadingArticles = document.getElementById('loading-articles')


const allNewsPopup = document.getElementById('all-news-popup')

const month_of_year = [
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec"
]

const fullMonthNames = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
]

const setCalendar = (start) => {

  let today;

  if (!start) {
    today = new Date()
  } else {
    today = start
  }

  document.querySelectorAll('.article').forEach(article => article.remove())
  document.querySelectorAll('.read-more').forEach(rm => rm.remove())
  document.querySelectorAll('.profit-loss').forEach(plText => plText.innerHTML = "")
  days.forEach(day => {
    day.classList.remove('up-day')
    day.classList.remove('down-day')
  })

  const monthStartDate = new Date(today.getFullYear(), today.getMonth(), 1)
  currentMonth = monthStartDate.getMonth();
  currentYear = monthStartDate.getFullYear();
  const dayStart = monthStartDate.getDay()
  const daysInMonth = getDaysInMonth(today.getFullYear(), today.getMonth())

//Set the first day
  let nextDay = 2
  let prevMonthDays = getDaysInMonth(today.getFullYear(), today.getMonth() - 1)
  let nextMonth = new Date(today.getFullYear(), today.getMonth() + 1, 1).getMonth()
  let nextMonthName = month_of_year[nextMonth];

  todayMonthDisplay.innerText = fullMonthNames[currentMonth]
  todayYearDisplay.innerText = today.getFullYear()


  days.forEach((day, i) => {
    day.classList.remove('current-day')
    let currentDay = day.querySelector('.day--date')
    if (i == dayStart) {
      currentDay.innerText = month_of_year[monthStartDate.getMonth()] + " 1"
      day.dataset.day = 1;
      day.dataset.month = today.getMonth();
      day.dataset.year = currentYear;
    } else if (i < dayStart) {
      let pastDay = prevMonthDays - (dayStart - (i + 1));
      currentDay.classList.add('opacity-40')
      currentDay.innerText = pastDay
      day.dataset.day = pastDay;
      day.dataset.month = today.getMonth() - 1 >= 0 ? today.getMonth() - 1 : 11;
      day.dataset.year = today.getMonth() - 1 >= 0 ? currentYear : currentYear - 1;

    } else {
      if (nextDay <= daysInMonth) {
        currentDay.innerText = nextDay
        day.dataset.day = nextDay;
        day.dataset.month = today.getMonth();
        day.dataset.year = currentYear
      } else if (nextDay == daysInMonth + 1) {
        currentDay.classList.add('opacity-40')
        currentDay.innerText = `${nextMonthName} 1`
        day.dataset.day = 1;
        day.dataset.month = today.getMonth() + 1 >= 11 ? 0 : today.getMonth() + 1;
        day.dataset.year = today.getMonth() + 1 >= 11 ? currentYear + 1 : currentYear
      } else {
        currentDay.classList.add('opacity-40')
        currentDay.innerHTML = nextDay - daysInMonth
        day.dataset.day = 1;
        day.dataset.month = today.getMonth() + 1 >= 11 ? 0 : today.getMonth() + 1;
        day.dataset.year = today.getMonth() + 1 >= 11 ? currentYear + 1 : currentYear
      }
      nextDay++
    }
  })

  //Set today box
  if (today.getMonth() == todaysDate.getMonth() && today.getFullYear() == todaysDate.getFullYear()) {
    days[(todaysDate.getDate() + dayStart) - 1].classList.add('current-day')
  } else if (today.getMonth() == todaysDate.getMonth() - 1 && today.getFullYear() == todaysDate.getFullYear()) {
    if (days[(todaysDate.getDate() - daysInMonth)]) {
      days[(todaysDate.getDate() + daysInMonth + dayStart) - 1].classList.add('current-day')
    }
  } else if (today.getMonth() == todaysDate.getMonth() + 1 && today.getFullYear() == todaysDate.getFullYear()) {
    if (days[(todaysDate.getDate() - daysInMonth)]) {
      days[(todaysDate.getDate() - daysInMonth)].classList.add('current-day')
    }
  }

  populateNews()
  getDayPL()
}

const getDaysInMonth = (year, month) => {
  return new Date(year, month + 1, 0).getDate()
}


const goForwardMonth = () => {
  currentMonth++;
  if (currentMonth == 12) {
    currentMonth = 0;
    currentYear++;
  }
  let start = new Date(currentYear, currentMonth, 1)
  setCalendar(start)
}


const goBackMonth = () => {
  currentMonth--;
  if (currentMonth == -1) {
    currentMonth = 11;
    currentYear--;
  }
  let start = new Date(currentYear, currentMonth, 1)
  setCalendar(start)
}

const goToToday = () => {
  let today = new Date()
  setCalendar(today)
}

const populateNews = () => {
  const endpoint = 'https://impulsetrading.io/api-new.php'
  const fd = new FormData()

  fd.append('action', 'get_news_calendar')

  fetch(endpoint, {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(data => {
      data.forEach(article => {
        let date = new Date(article.date + " " + article.time)
        days.forEach(day => {
          if (day.dataset.month == date.getMonth() && day.dataset.day == date.getDate() && day.dataset.year == date.getFullYear()) {
            console.log(article)
            if (article.title) {
              if (!day.querySelector('.read-more-news') && article.category == "news") {
                day.innerHTML += `<a href="#" class="px-1 rounded mb-1 block text-sm read-more read-more-news opacity-60 hover:opacity-100" data-count="1" data-type="news">View 1 article</a>`
              } else if (article.category == "news") {
                let readMore = day.querySelector('.read-more-news')
                let count = readMore.dataset.count
                count++
                readMore.dataset.count = count
                readMore.innerText = `View ${count} articles`
              } else if (!day.querySelector('.read-more-events') && article.category == "economic_event") {
                day.innerHTML += `<a href="#" class="px-1 rounded mb-1 block text-sm read-more read-more-events opacity-60 hover:opacity-100" data-count="1" data-type="economic_event">View 1 event</a>`
              } else if (article.category == "economic_event") {
                let readMore = day.querySelector('.read-more-events')
                let count = readMore.dataset.count
                count++
                readMore.dataset.count = count
                readMore.innerText = `View ${count} events`

              }
            }
          }
        })
      })
    })
}

//Generate Transaction History for P/L
const generateTransactionHistory = () => {
  oanda.transaction.since(oandaParams.accountId, {id: 1}, (data) => {
    data.body.transactions.forEach((transaction, i) => {
      //See if the order actually filled
      if (transaction.type == "ORDER_FILL") {

        console.log(transaction)
        let trans = {
          instrument: transaction.instrument,
          totalUnits: parseFloat(transaction.units),
          units: parseFloat(transaction.units),
          transactionId: transaction.orderID,
          accountBalance: transaction.accountBalance,
          price: transaction.price,
          time: transaction.time,
          pl: parseFloat(transaction.pl),
          reason: transaction.reason
        }

        transactionHistory.push(trans)
      }


      if (data.body.transactions.length == i + 1) {
        getDayPL()
      }
    })
  })
}

const getDayPL = () => {
  transactionHistory.forEach(trans => {
    if (trans.pl != 0) {
      const pl = parseFloat(trans.pl)
      const plDate = new Date(trans.time)
      days.forEach(day => {
        if (day.dataset.month == plDate.getMonth() && day.dataset.day == plDate.getDate() && day.dataset.year == plDate.getFullYear()) {
          const dayPL = day.querySelector('.profit-loss')
          let newPL;
          if (dayPL.innerText) {
            let oldPL = parseFloat(dayPL.innerHTML)
            newPL = (oldPL + pl).toFixed(2)
            dayPL.innerHTML = newPL
          } else {
            newPL = (pl).toFixed(2)
            dayPL.innerHTML = newPL;
          }

          if (newPL > 0) {
            day.classList.add('up-day')
          } else {
            day.classList.add('down-day')
          }
        }
      })
    }
  })
}

const initCalendar = () => {
  setCalendar()
  generateTransactionHistory()
}

const forwardBtn = document.getElementById('forward-month')
const backBtn = document.getElementById('back-month')
const todayBtn = document.getElementById('today-button')

forwardBtn.addEventListener('click', goForwardMonth)
backBtn.addEventListener('click', goBackMonth)
todayBtn.addEventListener('click', goToToday)

initCalendar()

const loadNewsPopup = (calendarDate, category) => {

  loadingArticles.classList.remove('hidden')
  const endpoint = 'https://impulsetrading.io/api-new.php'
  const fd = new FormData()

  fd.append('action', 'get_news_calendar')

  fetch(endpoint, {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(data => {
      allNewsPopup.innerHTML = `
        <p class="text-white text-lg">${parseInt(calendarDate.dataset.month) + 1}/${calendarDate.dataset.day}/${calendarDate.dataset.year}</p>
        <div id="all-news-articles" class="divide-y"></div>
      `
      const allNewsArticles = document.querySelector('#all-news-articles');
      data.forEach(article => {
        let date = new Date(article.date + " " + article.time)

        if (calendarDate.dataset.month == date.getMonth() && calendarDate.dataset.day == date.getDate() && calendarDate.dataset.year == date.getFullYear() && article.category == category) {
          if (article.title) {
            let description = article.desp
            description = description.replaceAll('&lt;', '<')
            description = description.replaceAll('&gt;', '>')
            description = description.replaceAll('<p>', '<p class="mb-4">')

            let bookmarkIcon

            if (bookmarkedArticles) {
              let parsed = JSON.parse(bookmarkedArticles)
              if (parsed.includes(article.id)) {
                bookmarkIcon = './assets/icons/bookmark_filled.svg'
              } else {
                bookmarkIcon = './assets/icons/bookmark_empty.svg'
              }
            } else {
              bookmarkIcon = './assets/icons/bookmark_empty.svg'
            }

            allNewsArticles.innerHTML += `
              <div class="text-sm">
                <div class="flex justify-between">
                  <button class="text-white text-opacity-50 hover:text-opacity-100 py-2 block w-full text-left truncate article-btn" data-id="${article.id}">${article.title}</button>
                  <button class="bookmark" data-id="${article.id}">
                    <img src="${bookmarkIcon}" alt="" class="pointer-events-none"/>
                  </button>
                </div>
                <div class="text-white opacity-80 pl-4 pb-2 description hidden">${description}</div>
              </div>
            `
          }
        }
      })
      allNewsPopup.showModal()
      loadingArticles.classList.add('hidden')
    })
}

document.addEventListener('click', function (e) {
  console.log(e.target)
  if (e.target.classList.contains('read-more')) {
    const day = e.target.parentNode
    const type = e.target.dataset.type
    checkBookmarks()
    loadNewsPopup(day, type)
  } else if (e.target.id == "all-news-popup") {
    // Check to see if clicking outside of box
    var rect = allNewsPopup.getBoundingClientRect();
    var isInDialog = (rect.top <= e.clientY && e.clientY <= rect.top + rect.height && rect.left <= e.clientX && e.clientX <= rect.left + rect.width);
    if (!isInDialog) {
      allNewsPopup.close();
    }
  } else if (e.target.classList.contains("article-btn")) {
    e.target.parentNode.parentNode.querySelector('.description').classList.toggle('hidden')

  } else if (e.target.classList.contains('bookmark')) {
    if (bookmarkedArticles) {
      const bookmarkParsed = JSON.parse(bookmarkedArticles)
      if (bookmarkParsed.includes(e.target.dataset.id)) {
        const fd = new FormData();
        fd.append('action', 'delete_bookmark')
        fd.append('post_id', e.target.dataset.id)
        fd.append('uid', localStorage.getItem('usr'))

        fetch('https://impulsetrading.io/api-new.php', {
          method: "POST",
          body: fd
        })
        e.target.querySelector('img').src = './assets/icons/bookmark_empty.svg'
        removeBookmarkFromStorage(e.target.dataset.id)


      } else {
        const fd = new FormData();
        fd.append('action', 'update_bookmarks')
        fd.append('post_id', e.target.dataset.id)
        fd.append('uid', localStorage.getItem('usr'))

        fetch('https://impulsetrading.io/api-new.php', {
          method: "POST",
          body: fd
        })
        e.target.querySelector('img').src = './assets/icons/bookmark_filled.svg'
        addBookmarkToStorage(e.target.dataset.id)
      }
    }
  }
})


const checkBookmarks = () => {
  const fd = new FormData();
  fd.append('action', 'fetch_bookmarked_posts')
  fd.append('uid', localStorage.getItem('usr'))
  fetch('https://impulsetrading.io/api-new.php', {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(bookmarks => {
      // console.log(bookmarks)
      bookmarks.forEach(bookmark => {
        console.log(bookmark)
        console.log(bookmark.post_id)
        addBookmarkToStorage(bookmark.post_id)
      })
    })
}


const addBookmarkToStorage = (post_id) => {
  if (bookmarkedArticles) {
    const bookmarkParsed = JSON.parse(bookmarkedArticles)
    if (!bookmarkParsed.includes(post_id)) {
      bookmarkParsed.push(post_id)
      localStorage.setItem('bookmarked_articles', JSON.stringify(bookmarkParsed))
      bookmarkedArticles = JSON.stringify(bookmarkParsed)
    }
  } else {
    let post = [post_id]
    localStorage.setItem('bookmarked_articles', JSON.stringify(post))
    bookmarkedArticles = JSON.stringify(post)
  }
}

const removeBookmarkFromStorage = (post_id) => {
  const bookmarkParsed = JSON.parse(bookmarkedArticles)
  const index = bookmarkParsed.indexOf(post_id)
  if (index > -1) {
    bookmarkParsed.splice(index, 1)
    localStorage.setItem('bookmarked_articles', JSON.stringify(bookmarkParsed))
    bookmarkedArticles = JSON.stringify(bookmarkParsed)
  }
}