const transactionHistory = []
const instrumentHistory = []
let currentMonth;
let currentYear;
const days = document.querySelectorAll('.day');
const todayMonthDisplay = document.getElementById('today-month')
const todayYearDisplay = document.getElementById('today-year')
const todaysDate = new Date();

const month_of_year = [
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec"
]

const fullMonthNames = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
]

const setCalendar = (start) => {

  let today;

  if (!start) {
    today = new Date()
  } else {
    today = start
  }

  document.querySelectorAll('.article').forEach(article => article.remove())
  document.querySelectorAll('.read-more').forEach(rm => rm.remove())
  document.querySelectorAll('.profit-loss').forEach(plText => plText.innerHTML = "")

  const monthStartDate = new Date(today.getFullYear(), today.getMonth(), 1)
  currentMonth = monthStartDate.getMonth();
  currentYear = monthStartDate.getFullYear();
  const dayStart = monthStartDate.getDay()
  const daysInMonth = getDaysInMonth(today.getFullYear(), today.getMonth())

//Set the first day
  let nextDay = 2
  let prevMonthDays = getDaysInMonth(today.getFullYear(), today.getMonth() - 1)
  let nextMonth = new Date(today.getFullYear(), today.getMonth() + 1, 1).getMonth()
  let nextMonthName = month_of_year[nextMonth];

  todayMonthDisplay.innerText = fullMonthNames[currentMonth]
  todayYearDisplay.innerText = today.getFullYear()


  days.forEach((day, i) => {
    day.classList.remove('current-day')
    let currentDay = day.querySelector('.day--date')
    if (i == dayStart) {
      currentDay.innerText = month_of_year[monthStartDate.getMonth()] + " 1"
      day.dataset.day = 1;
      day.dataset.month = today.getMonth();
      day.dataset.year = currentYear;
    } else if (i < dayStart) {
      let pastDay = prevMonthDays - (dayStart - (i + 1));
      currentDay.classList.add('opacity-40')
      currentDay.innerText = pastDay
      day.dataset.day = pastDay;
      day.dataset.month = today.getMonth() - 1 >= 0 ? today.getMonth() - 1 : 11;
      day.dataset.year = today.getMonth() - 1 >= 0 ? currentYear : currentYear - 1;

    } else {
      if (nextDay <= daysInMonth) {
        currentDay.innerText = nextDay
        day.dataset.day = nextDay;
        day.dataset.month = today.getMonth();
        day.dataset.year = currentYear
      } else if (nextDay == daysInMonth + 1) {
        currentDay.classList.add('opacity-40')
        currentDay.innerText = `${nextMonthName} 1`
        day.dataset.day = 1;
        day.dataset.month = today.getMonth() + 1 >= 11 ? 0 : today.getMonth() + 1;
        day.dataset.year = today.getMonth() + 1 >= 11 ? currentYear + 1 : currentYear
      } else {
        currentDay.classList.add('opacity-40')
        currentDay.innerHTML = nextDay - daysInMonth
        day.dataset.day = 1;
        day.dataset.month = today.getMonth() + 1 >= 11 ? 0 : today.getMonth() + 1;
        day.dataset.year = today.getMonth() + 1 >= 11 ? currentYear + 1 : currentYear
      }
      nextDay++
    }
  })

  //Set today box
  if (today.getMonth() == todaysDate.getMonth() && today.getFullYear() == todaysDate.getFullYear()) {
    days[(todaysDate.getDate() + dayStart) - 1].classList.add('current-day')
  } else if (today.getMonth() == todaysDate.getMonth() - 1 && today.getFullYear() == todaysDate.getFullYear()) {
    if (days[(todaysDate.getDate() - daysInMonth)]) {
      days[(todaysDate.getDate() + daysInMonth + dayStart) - 1].classList.add('current-day')
    }
  } else if (today.getMonth() == todaysDate.getMonth() + 1 && today.getFullYear() == todaysDate.getFullYear()) {
    if (days[(todaysDate.getDate() - daysInMonth)]) {
      days[(todaysDate.getDate() - daysInMonth)].classList.add('current-day')
    }
  }

  populateNews()
}

const getDaysInMonth = (year, month) => {
  return new Date(year, month + 1, 0).getDate()
}


const goForwardMonth = () => {
  currentMonth++;
  if (currentMonth == 12) {
    currentMonth = 0;
    currentYear++;
  }
  let start = new Date(currentYear, currentMonth, 1)
  setCalendar(start)
}


const goBackMonth = () => {
  currentMonth--;
  if (currentMonth == -1) {
    currentMonth = 11;
    currentYear--;
  }
  let start = new Date(currentYear, currentMonth, 1)
  setCalendar(start)
}

const goToToday = () => {
  let today = new Date()
  setCalendar(today)
}

const populateNews = () => {
  const endpoint = 'https://impulsetrading.io/api.php'
  const fd = new FormData()

  fd.append('action', 'get_posts')

  fetch(endpoint, {
    method: "POST",
    body: fd
  }).then(res => res.json())
    .then(data => {
      data.forEach(article => {
        let date = new Date(article.date + " " + article.time)
        days.forEach(day => {
          if (day.dataset.month == date.getMonth() && day.dataset.day == date.getDate() && day.dataset.year == date.getFullYear()) {
            if (!day.querySelector('.article')) {
              day.innerHTML += `<a href="#" class="bg-brand px-1 rounded bg-opacity-50 mb-1 block text-sm article truncate">${article.title}</a>`
            } else {
              if (!day.querySelector('.read-more')) {
                day.innerHTML += `<a href="#" class="px-1 rounded mb-1 block text-sm read-more" data-count="1">1 more...</a>`
              } else {
                let readMore = day.querySelector('.read-more')
                let count = readMore.dataset.count
                count++
                readMore.dataset.count = count
                readMore.innerText = `${count} more...`

              }
            }
          }
        })
      })
    })
}

//Generate Transaction History for P/L
const generateTransactionHistory = () => {
  oanda.transaction.since(oandaParams.accountId, {id: 1}, (data) => {
    data.body.transactions.forEach((transaction, i) => {
      //See if the order actually filled
      if (transaction.type == "ORDER_FILL") {

        //See if instrument already exists. If it does, alter it. If it doesn't, create it.
        let searchObj = transactionHistory.find(tranInst => tranInst.instrument == transaction.instrument)

        if (searchObj) {
          let transInfo = {
            instrument: transaction.instrument,
            units: parseFloat(transaction.units),
            totalUnits: searchObj.totalUnits + parseFloat(transaction.units),
            transactionId: transaction.orderID,
            accountBalance: transaction.accountBalance,
            price: transaction.price,
            time: transaction.time,
            pl: parseFloat(transaction.pl)
          }

          searchObj.totalPL += parseFloat(transaction.pl)
          searchObj.totalUnits += parseFloat(transaction.units)
          searchObj.transInfo.push(transInfo)
        } else {

          let trans = {
            instrument: transaction.instrument,
            totalUnits: parseFloat(transaction.units),
            totalPL: parseFloat(transaction.pl),
            transInfo: [
              {
                instrument: transaction.instrument,
                totalUnits: parseFloat(transaction.units),
                units: parseFloat(transaction.units),
                transactionId: transaction.orderID,
                accountBalance: transaction.accountBalance,
                price: transaction.price,
                time: transaction.time,
                pl: parseFloat(transaction.pl)
              }
            ]
          }
          transactionHistory.push(trans)
        }
      }

      if (data.body.transactions.length == i + 1) {
        generateCandles()
      }
    })
  })
}

const calendarChart = {
  granularity: 'D'
}


const generateCandles = () => {
  transactionHistory.forEach((transaction, i) => {
    oanda.instrument.candles(transaction.instrument, calendarChart, (data) => {
      let instr = {
        instrument: transaction.instrument,
        candles: data.body.candles
      }
      instrumentHistory.push(instr)
      if (transactionHistory.length == instrumentHistory.length) {
        generatePL()
      }
    })
  })
}

const generatePL = () => {
  // transactionHistory.forEach(transaction => {
  //   transaction.transInfo.forEach(info => {
  //     // console.log(info)
  //     let transactionDate = new Date(info.time)
  //     // transactionDate.setHours(0, 0, 0 ,0)
  //     let candles = instrumentHistory.find(inst => inst.instrument == info.instrument)
  //     days.forEach(day => {
  //       candles.candles.forEach(candle => {
  //         let candleDate = new Date(candle.time)
  //       })
  //     })
  //
  //
  //   })
  // })

  // See if they have any units available in their account of any position

  transactionHistory.forEach(trans => {
    trans.transInfo.forEach(info => {
      // console.log(info)
      const transTime = new Date(info.time)
      transTime.setHours(0, 0, 0, 0)

      //Subtract price from candlestick price each day of the month * units

      if (info.units != 0) {
        // console.log(transTime)
        console.log(info.totalUnits, info.instrument)
        let candles = instrumentHistory.find(inst => inst.instrument == info.instrument)
        candles.candles.forEach(candle => {
          let candleTime = new Date(candle.time)
          days.forEach(day => {
            if (candleTime.getDate() == day.dataset.day && candleTime.getMonth() == day.dataset.month && candleTime.getFullYear() == day.dataset.year) {
              let plDisplay = day.querySelector('.profit-loss')
              plDisplay.innerText = candle.mid.c
            }
          })
        })
      }
      // Take the current day and the current candle and compare for P/L

    })
  })

}


const initCalendar = () => {
  setCalendar()
  populateNews()
  generateTransactionHistory()
}

const forwardBtn = document.getElementById('forward-month')
const backBtn = document.getElementById('back-month')
const todayBtn = document.getElementById('today-button')

forwardBtn.addEventListener('click', goForwardMonth)
backBtn.addEventListener('click', goBackMonth)
todayBtn.addEventListener('click', goToToday)

initCalendar()


