<?php 

include('view/new_header_file.php');

include_once("classes/database.class.php");

include_once("classes/oanda.php");

include_once('classes/phpToPDF.php');

$nowDate = date('m/d/Y');

?>


<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />


<style type="text/css">
	
	.dataTables_wrapper
	{
		margin-top: 50px !important;
	}
	.dataTables_length > label > select
	{
		text-transform: none;
		background-color: #202943;
		color: #fff;
		border-color: #202943;
		padding: 5px;
		width: 60px;
		margin-left: 10px;
		margin-right: 10px;
	}
	#tradeTable > thead, #tradeTable > tfoot
	{
		background-color: #131722 !important;
		color: #fff !important;
		padding: 10px !important;
	}
	table.dataTable.stripe tbody tr.odd, table.dataTable.display tbody tr.odd
	{
		color: #fff !important;
		background: #202943 !important;
	}
	table.dataTable.stripe tbody tr.odd, table.dataTable.display tbody tr.odd > .sorting_1
	{
		color: #fff !important;
		background: #202943 !important;
	}
	table.dataTable.display tbody tr.even > .sorting_1, table.dataTable.order-column.stripe tbody tr.even > .sorting_1
	{
		
		background: #0E1528 !important;
		color: #fff;	
	}
	table.dataTable tbody tr
	{
		background: #0E1528 !important;
		color: #fff;
	}
	#tradeTable > tfoot
	{
		padding-top: 10px !important;
		padding-bottom: 10px !important;
	}
	table.dataTable thead .sorting_asc
	{
		padding: 20px !important;
	}
	.dataTables_info
	{
		color: #fff !important;
	}
	.paginate_button
	{
		color: #fff !important;
	}
	.dataTables_wrapper .dataTables_paginate .paginate_button.disabled, .dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover, .dataTables_wrapper .dataTables_paginate .paginate_button.disabled:active
	{
		color: #fff !important;
	}
	.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover
	{
		background: #202943 !important;
		color: #fff !important;
		border-color: #202943 !important;
	}
	.dataTables_wrapper .dataTables_filter input
	{
		background: #202943 !important;
		color: #fff !important;
		border: none !important;
		padding-top: 5px !important;
		padding-bottom: 5px !important;
	}
</style>
  
<div class="container trade-container">

<div class="row">

	<div class="col-md-12 col-lg-12">

		<div class="row" style="margin-top: 50px;">
			<div class="col-md-2">
				<p style="color: #fff;font-size: 18px;padding-top: 15px;">Select Date Range</p>
			</div>
			<div class="col-md-6">
				<input type="text" name="daterange" value="09/21/2019 - <?=$nowDate ?>" id="dateRange" class="form form-control newformcontrol" />
			</div>
			<div class="col-md-4">
				<div><a href="javascript:void(0)" onclick="gethistory()" class="crypt-button-green-full">GET HISTORY</a></div> 
			</div>
			
		</div>
		<table id="tradeTable" class="display">
		    <thead>
		        <tr>
		            <th>Date</th>
		            <th>Instrument</th>
		            <th>Trade Type</th>
		            <th>Current Balance</th>
		            <th>Profit / Loss</th>
		        </tr>
		    </thead>
		    <tbody id="tbody">
		    </tbody>
		   	<tfoot>
		   		<tr>
		   			<th id="topened" colspan="2"></th>
		   			<th id="tclosed"></th>
		   			<th id="inloss"></th>
		   			<th id="profit">Profit</th>
		   		</tr>
		   	</tfoot>
		</table>

	</div>
	<p style="color: #fff;">
	<?php 

	print_r($trades);

	?>
	</p>
</div>
	

</div>



<?php

include('view/new_footer_file.php');

?>


<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script type="text/javascript">
	$(document).ready( function () {
    	$('#tradeTable').DataTable();
	});
</script>

<script>
$(function() {
  $('input[name="daterange"]').daterangepicker({
    opens: 'left'
  }, function(start, end, label) {
    console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
  });
});
</script>
<script type="text/javascript">
	function gethistory()
	{
		$('#tradeTable').DataTable().clear().draw();
		var table = $('#tradeTable').DataTable();
		var dR = $("#dateRange").val();
		var split = dR.split("-");
		var start = split[0];
		var end = split[1];
		var uid = '<?=$userUId; ?>';
		$.post('/trade-history-api.php', {start:start, end:end, uid:uid})
		.done(function (data)
		{
			var result = JSON.parse(data);
			
			var res = result.result;

			var tradeOpened = 0;

			var tradeClosed = 0;

			var in_loss = 0;
			
			for (var i = 0; i < res.length; i++) {

				var resu = res[i];

				var date = resu.date;

				var currentBalance = resu.balance;

				var instrument = resu.instrument;

				var trade_type = resu.tradetype;

				var profit = resu.profit;

				var full_profit = resu.fullprofit;

				if (full_profit <= 0) {

					$("#profit").html('<span style="color:red;">'+full_profit + '</span>');
				}else{

					$("#profit").html('<span style="color:green;">'+full_profit + '</span>');
				}

				

				if (trade_type == 'MARKET_ORDER') {

					trade_type = 'TRADE OPENED';

					tradeOpened++;
				}

				if (trade_type == 'MARKET_ORDER_TRADE_CLOSE') {

					trade_type = 'TRADE CLOSED';

					tradeClosed++;
				}

				if (trade_type == 'STOP_LOSS_ORDER') {
					trade_type = 'TRADE STOPPED DUE TO LOSS';
					in_loss++;
				}

				if (trade_type == 'MARKET_ORDER_POSITION_CLOSEOUT') {

					trade_type = 'TRADE CLOSED - POSTION CLOSED';

					tradeClosed++;
				}

				table.row.add([date, instrument, trade_type, currentBalance, profit]);
			}


			$("#topened").html('Trades Opened : '+tradeOpened);
			$("#tclosed").html('Trades Closed : '+tradeClosed);
			$("#inloss").html('Trades in loss : '+in_loss);


			table.draw();

		});
	}
</script>