<?php

/**
 * Created by PhpStorm.
 * User: brycemoral
 * Date: 6/23/16
 * Time: 12:23 AM
 */
class localStock
{

    public $identifier;
    public $macd; //Using For Prototype
    public $currentTrend; //Using For prototype // 	Between -1 and 1;
    public $rateOfChange; //Using For Prototype
    public $RSI; //Using For ProtoType
    public $pastPrice; //Using For Prototype
    public $currentAsking; //Using For Prototype
    public $currentBidding; //Using For Prototype
    public $currentRow; //Using For Prototype
    public $volumeStatus; //Using For Prototype

// 	3 part array
    public $sma;
    public $ema;
    public $rows = array();
    public $crossed = false;
    public $bollingerBands;
    public $ch;
    public $massData;
    public $startDate;
    public $endDate;
    public $individualStock = array();
    public $timeFrame;
    public $units;
    public $currentPosition = "buy";
    // Range of -1 ... 1
    function __construct(){
        $this->refresh();
        $this->getTrend();
        $this->getATR(7);
        $this->getBarHistory(7);
    }

    private function getTrend(){
        //This will produce the MACD for the stock at the current time
        $this->getMACD();
        //The following will produce the trend of the stock
        if($this->sma[0] < $this->sma[1]){
            if($this->sma[1] < $this->sma[2]){
                $this->currentTrend = -1;
                $this->crossed = false;
            }
            else{
                $this->currentTrend = -0.5;
                $this->crossed = true;
            }
        }
        else if($this->sma[0] > $this->sma[1]){
            if($this->sma[1] > $this->sma[2]){
                $this->currentTrend = 1;
                $this->crossed = false;
            }
            else{
                $this->currentTrend = 0.5;
                $this->crossed = true;
            }
        }
    }
    private function getBar($barPosition){
        $tempValue = array();
        while($barPosition > 0){
            $tempValue[] = $this->individualStock[$barPosition]->biddingPrice;
            $barPosition--;
        }
        $this->rows = $tempValue;
        return $tempValue;
    }
    private function getMACD(){
        $bars = $this->getBar(7);
        $sma = $this->getSMA($bars);
        $ema = $this->getEMA($bars);
        $this->macd = ($ema - $sma[0]) / 100;
    }
    private function getSMA($bars){
        $firstDayTemp = array($bars[0], $bars[1], $bars[2], $bars[3], $bars[4]);
        $secondDayTemp = array($bars[1], $bars[2], $bars[3], $bars[4], $bars[5]);
        $thirdDayTemp = array($bars[2], $bars[3], $bars[4], $bars[5], $bars[6]);
// 		Looping through to create the SMA
        for($i = 0; $i < 5; $i++){
            $this->firstSMA += $bars[$i];
            $this->secondSMA += $bars[$i+1];
            $this->thirdSMA += $bars[$i+2];
        }
        $sma = array(($this->firstSMA / 5), ($this->secondSMA / 5), ($this->thirdSMA / 5));
        $this->sma = $sma;
        return $sma;
    }
    private function getEMA($bars){
        $firstDayTemp = array($bars[0], $bars[1], $bars[2], $bars[3], $bars[4]);
        $secondDayTemp = array($bars[1], $bars[2], $bars[3], $bars[4], $bars[5]);
        $thirdDayTemp = array($bars[2], $bars[3], $bars[4], $bars[5], $bars[6]);
        $multiplier = (2 / (5 +1));
        $ema = ($bars[sizeof($bars)] - $this->sma[0]) * $multiplier + $this->sma[0];
        $this->ema = $ema;
        return $ema;
    }
    private function getBarHistory($barPosition){
        for($i = sizeof($this->individualStock) - 10; $i < sizeof($this->individualStock)-1; $i++){
            $this->pastPrice += $this->individualStock[$i+1]->endBiddingPrice - $this->individualStock[$i]->endBiddingPrice;
        }
        return $this->pastPrice;
    }
    private function checkVolume($barLocation){
        if($this->individualStock[$barLocation]->volume >= $this->individualStock[$barLocation - 1]->volume){
            if($this->individualStock[$barLocation]->biddingPrice >= $this->individualStock[$barLocation -1]->biddingPrice){
                $this->volumeStatus = 0;
            }
            else {
                $this->volumeStatus = -1;
            }
        }
        else if($this->individualStock[$barLocation]->volume <= $this->individualStock[$barLocation - 1]->volume) {
            if($this->individualStock[$barLocation]->biddingPrice <= $this->individualStock[$barLocation -1]->biddingPrice){
                $this->volumeStatus = 0;
            }
            else{
                $this->volumeStatus = -1;
            }
        }
    }
    private function getRSI($bars){
        $tempValuesWin = 0;
        $tempValuesLoss = 0;
        foreach($this->individualStock as $bar){
            if($bar->startingBiddingPrice < $bar->endingBiddingPrice){
                $tempValuesLoss +=  $bar->startingBiddingPrice - $bar->endingBiddingPrice;
            }
            else{
                $tempValuesWin += $bar->startingBiddingPrice - $bar->endingBiddingPrice;
            }
        }
        return (100 - (100/ (1 + (($tempValuesWin / sizeof($this->individualStock)) / ($tempValuesLoss / sizeof($this->individualStock))))));
    }
    private function getATR($bars){
        $tempValues = 0;
        foreach($this->individualStock as $bar){
            $tempValues +=  abs($bar->startingBiddingPrice - $bar->endingBiddingPrice);
        }
        $this->rateOfChange =  abs($tempValues / sizeof($this->individualStock)) / 100;
    }
// End of the Class
}



?>
