<?php
include_once('database.class.php');
include_once('neural.class.php');
include_once('node.class.php');
include_once('oanda.php');
include_once('singleStock.class.php');
include_once('stock.class.php');
include_once('localStock.php');

/**
 * Created by PhpStorm.
 * User: brycemoral
 * Date: 6/23/16
 * Time: 12:12 AM
 */
class history
{
    public $winCounter;
    public $lossCounter;
    public $winnerStreak;
    public $loserStreak;
    public $highestWinnerStreak;
    public $highestLoserStreak;
    public $currentDate;
    public $database;

    public $identifier;
    public $macd; //Using For Prototype
    public $currentTrend; //Using For prototype // 	Between -1 and 1;
    public $rateOfChange; //Using For Prototype
    public $RSI; //Using For ProtoType
    public $pastPrice; //Using For Prototype
    public $currentAsking; //Using For Prototype
    public $currentBidding; //Using For Prototype
    public $currentRow; //Using For Prototype
    public $volumeStatus; //Using For Prototype

// 	3 part array
    public $sma;
    public $ema;
    public $rows = array();
    public $crossed = false;
    public $bollingerBands;
    public $ch;
    public $massData;
    public $startDate;
    public $endDate;
    public $individualStock = array();
    public $timeFrame;
    public $units;
    public $currentPosition = "buy";
    public $nodes = array();
    public $unitCount = 0;
    public $stockList = array();

    function __construct($currentDate){
        $this->currentDate = '2013-02-01';
        $this->winCounter = 0;
        $this->lossCounter = 0;
        $this->winnerStreak = 0;
        $this->highestLoserStreak = 0;
        $this->loserStreak = 0;
        $this->highestWinnerStreak = 0;
        $this->currentPosition = "buy";
        $this->database = new database();
        for($i = 0; $i < 5; $i++){
            $this->nodes[] = new node();
        }
        loop();
    }
    private function loop(){
        $stmt = $this->database->db->prepare("SELECT * FROM chartData WHERE startDate = :startDate ORDER BY startDate desc LIMIT 6");
        while(strtotime($this->currentDate) < date("now")){
            $stmt->execute(array(':startDate' => $this->currentDate));
            $tempData = $stmt->fetchAll(PDO::FETCH_OBJ);
            $this->currentDate = strtotime($this->currentDate . "+1 hour");
            $stock = new localStock();
            $i = 0;
            foreach($tempData as $temp){
                $this->stockList[$i]= array('startDate' => $temp->startDate, ':hours' => $temp->hours, ':open' => $temp->open, ':high' => $temp->high, ':low' => $temp->low, ':close' => $temp->close, ':volume' => $temp->volume);
                $i++;
            }
            $rows = $this->stockList;

            echo $this->currentPosition;
         //   if($this->currentPosition == $stock->currentPosition){
                //keep working
                //dont sell

        //    }
          //  else {
           //     if($this->currentPosition == "buy"){
                    //check if the chart has gone down or up
                    //if down...reset the counter
                    //else ... start new system
            //    }
           // }
        }
    }

    private function calculation(){
        $this->nodes[0]->assignNodeRandomize($this->randomizer());
        $this->nodes[1]->assignNodeRandomize($this->randomizer());
        $this->nodes[2]->assignNodeRandomize($this->randomizer());
        $this->nodes[3]->assignNodeRandomize($this->randomizer());
        $this->nodes[4]->assignNodeRandomize($this->randomizer());

        $this->nodes[0]->assignNodeInput($this->currentTrend);
        $this->nodes[1]->assignNodeInput($this->macd);
        $this->nodes[2]->assignNodeInput($this->rateOfChange);
        $this->nodes[3]->assignNodeInput($this->pastPrice);
        $this->nodes[4]->assignNodeInput($this->volumeStatus);

        $this->nodes[0]->assignNodeOutput();
        $this->nodes[1]->assignNodeOutput();
        $this->nodes[2]->assignNodeOutput();
        $this->nodes[3]->assignNodeOutput();
        $this->nodes[4]->assignNodeOutput();
        $finalOutput = $this->nodes[0]->nodeOutput + $this->nodes[1]->nodeOutput + $this->nodes[2]->nodeOutput + $this->nodes[3]->nodeOutput + $this->nodes[4]->nodeOutput;
        $tempDecision = "none";
        if ($finalOutput > 0 && $finalOutput < 0.65) {
            $this->currentPosition = "Buy";
           } else if ($finalOutput >= 0.65) {
            $this->currentPosition  = "Strong Buy";
        } else if ($finalOutput < 0 && $finalOutput > -0.65) {
            $this->currentPosition  = "Short";
        } else if ($finalOutput <= -0.65) {
            $this->currentPosition  = "Strong Short";
        }
    }
    private function randomizer(){
        $min = 0;
        $max = 1;
        $val = $min + mt_rand() / mt_getrandmax() * ($max - $min);
        return $val;
    }
    // Range of -1 ... 1
    private function checking(){
        $this->getTrend();
        $this->getATR(7);
        $this->getBarHistory(7);
        $this->getRSI(7);
        $this->checkVolume(7);
        $this->calculation();
    }

    private function getTrend(){
        //This will produce the MACD for the stock at the current time
        $this->getMACD();
        //The following will produce the trend of the stock
        if($this->sma[0] < $this->sma[1]){
            if($this->sma[1] < $this->sma[2]){
                $this->currentTrend = -1;
                $this->crossed = false;
            }
            else{
                $this->currentTrend = -0.5;
                $this->crossed = true;
            }
        }
        else if($this->sma[0] > $this->sma[1]){
            if($this->sma[1] > $this->sma[2]){
                $this->currentTrend = 1;
                $this->crossed = false;
            }
            else{
                $this->currentTrend = 0.5;
                $this->crossed = true;
            }
        }
    }
    private function getMACD(){
        $sma = $this->getSMA($this->stockList);
        $ema = $this->getEMA($this->stockList);
        $this->macd = ($ema - $sma[0]) / 100;
    }
    private function getSMA($bars){
        $firstDayTemp = array($bars[0]['close'], $bars[1]['close'], $bars[2]['close'], $bars[3]['close'], $bars[4]['close']);
        $secondDayTemp = array($bars[1]['close'], $bars[2]['close'], $bars[3]['close'], $bars[4]['close'], $bars[5]['close']);
        $thirdDayTemp = array($bars[2]['close'], $bars[3]['close'], $bars[4]['close'], $bars[5]['close'], $bars[6]['close']);
// 		Looping through to create the SMA
        for($i = 0; $i < 5; $i++){
            $this->firstSMA += $bars[$i];
            $this->secondSMA += $bars[$i+1];
            $this->thirdSMA += $bars[$i+2];
        }
        $sma = array(($this->firstSMA / 5), ($this->secondSMA / 5), ($this->thirdSMA / 5));
        $this->sma = $sma;
        return $sma;
    }
    private function getEMA($bars){
        $firstDayTemp = array($bars[0]['close'], $bars[1]['close'], $bars[2]['close'], $bars[3]['close'], $bars[4]['close']);
        $secondDayTemp = array($bars[1]['close'], $bars[2]['close'], $bars[3]['close'], $bars[4]['close'], $bars[5]['close']);
        $thirdDayTemp = array($bars[2]['close'], $bars[3]['close'], $bars[4]['close'], $bars[5]['close'], $bars[6]['close']);
        $multiplier = (2 / (5 +1));
        $ema = ($bars[sizeof($bars)] - $this->sma[0]) * $multiplier + $this->sma[0];
        $this->ema = $ema;
        return $ema;
    }
    private function getBarHistory($barPosition){
        for($i = sizeof($this->stockList) - 10; $i < sizeof($this->stockList)-1; $i++){
            $this->pastPrice += $this->stockList[$i+1]['close'] - $this->stockList[$i]['close'];
        }
        return $this->pastPrice;
    }
    private function checkVolume($barLocation){
        if($this->stockList[$barLocation]['volume'] >= $this->stockList[$barLocation - 1]['volume']){
            if($this->stockList[$barLocation]['close'] >= $this->stockList[$barLocation -1]['close']){
                $this->volumeStatus = 0;
            }
            else {
                $this->volumeStatus = -1;
            }
        }
        else if($this->stockList[$barLocation]['volume'] <= $this->stockList[$barLocation - 1]['volume']) {
            if($this->stockList[$barLocation]['close'] <= $this->stockList[$barLocation -1]['close']){
                $this->volumeStatus = 0;
            }
            else{
                $this->volumeStatus = -1;
            }
        }
    }
    private function getRSI($bars){
        $tempValuesWin = 0;
        $tempValuesLoss = 0;
        foreach($this->stockList as $bar){
            if($bar['open'] < $bar['close']){
                $tempValuesLoss +=  $bar['open'] - $bar['close'];
            }
            else{
                $tempValuesWin += $bar['open'] - $bar['close'];
            }
        }
        return (100 - (100/ (1 + (($tempValuesWin / sizeof($this->stockList)) / ($tempValuesLoss / sizeof($this->stockList))))));
    }
    private function getATR($bars){
        $tempValues = 0;
        foreach($this->stockList as $bar){
            $tempValues +=  abs($bar['open'] - $bar['close']);
        }
        $this->rateOfChange =  abs($tempValues / sizeof($this->stockList)) / 100;
    }

}
?>